/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-01-08 04:09:35 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `dlhwp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2914 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3547 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=386 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=362 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `dlhwp_users` VALUES 
("1","Michael Albert","$P$BdtJBxFcDgyQp1MstFG8WonVWHT2GA.","michael-albert","michael@zahlenwerk21.de","https://dev.lengauerhof.at/dev/dev","2023-07-27 17:59:28","","0","Michael Albert"),
("2","Corinna","$P$BuXy9J7rpR8SRZHhc9Hyyf2Kqq2X8e0","corinna","corinna@zahlenwerk21.de","","2023-11-15 12:36:43","","0","Corinna Charné"),
("3","Jenny Jaumann","$P$BFEA5i1u/R2iZv3sO5y5GA3/zN7M8s0","jenny-jaumann","info@jennyjaumann.de","","2023-11-22 14:32:05","","0","Jenny Jaumann");

INSERT IGNORE INTO `dlhwp_usermeta` VALUES 
("1","1","nickname","Michael Albert"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","dlhwp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","dlhwp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","dlhwp_dashboard_quick_press_last_post_id","352"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"24.134.18.0\";}"),
("19","1","dlhwp_elementor_connect_common_data","a:6:{s:9:\"client_id\";s:32:\"Jk3P6KPxMdwqbZKY8jQE6rikJiab9w4O\";s:11:\"auth_secret\";s:32:\"xvHfL7FdnBNMhZHFzWO2LlsPxHhf6ZpE\";s:12:\"access_token\";s:295:\"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOjE2ODU0MjIsImF1ZCI6Imh0dHBzOi8vZGV2LmxlbmdhdWVyaG9mLmF0LyIsImNsaWVudF9pZCI6IkprM1A2S1B4TWR3cWJaS1k4alFFNnJpa0ppYWI5dzRPIiwiY29ubmVjdF90eXBlIjoiYWN0aXZhdGUiLCJpYXQiOjE3MDAwNTE2NTksImV4cCI6MzE3MjQ0NDk0MDU5fQ.D8pp20vLfE47S447A7HIQNj342RbiF3tqqI0kjf6N1M\";s:19:\"access_token_secret\";s:32:\"x2INiHOibggxFs9Cnn0x57XuKWIooVwk\";s:10:\"token_type\";s:6:\"bearer\";s:4:\"user\";O:8:\"stdClass\":1:{s:5:\"email\";s:23:\"michael@zahlenwerk21.de\";}}"),
("20","1","elementor_introduction","a:5:{s:27:\"ai-get-started-announcement\";b:1;s:7:\"exit_to\";b:1;s:6:\"e-apps\";b:1;s:20:\"globals_introduction\";b:1;s:14:\"ai_get_started\";b:1;}"),
("21","1","announcements_user_counter","1"),
("22","1","closedpostboxes_dashboard","a:0:{}"),
("23","1","metaboxhidden_dashboard","a:7:{i:0;s:24:\"wc_admin_dashboard_setup\";i:1;s:20:\"e-dashboard-overview\";i:2;s:19:\"dashboard_right_now\";i:3;s:18:\"dashboard_activity\";i:4;s:21:\"dashboard_quick_press\";i:5;s:17:\"dashboard_primary\";i:6;s:27:\"duplicator_dashboard_widget\";}"),
("24","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:81:\"e-dashboard-overview,dashboard_site_health,dashboard_right_now,dashboard_activity\";s:4:\"side\";s:67:\"dashboard_quick_press,dashboard_primary,duplicator_dashboard_widget\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("25","1","dlhwp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2023-07-27T18:18:52.509Z\";}"),
("26","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("27","1","metaboxhidden_nav-menus","a:2:{i:0;s:28:\"add-post-type-e-landing-page\";i:1;s:12:\"add-post_tag\";}"),
("28","1","elementor_preferences","a:1:{s:7:\"exit_to\";s:9:\"dashboard\";}"),
("29","1","dlhwp_user-settings","editor=tinymce&libraryContent=browse"),
("30","1","dlhwp_user-settings-time","1700075388"),
("31","1","default_password_nag",""),
("32","1","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.18.2\";}}}"),
("34","2","nickname","Corinna"),
("35","2","first_name","Corinna"),
("36","2","last_name","Charné"),
("37","2","description",""),
("38","2","rich_editing","true"),
("39","2","syntax_highlighting","true"),
("40","2","comment_shortcuts","false"),
("41","2","admin_color","fresh"),
("42","2","use_ssl","0"),
("43","2","show_admin_bar_front","true"),
("44","2","locale",""),
("45","2","dlhwp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("46","2","dlhwp_user_level","10"),
("47","2","dismissed_wp_pointers",""),
("48","1","_order_count","0"),
("49","1","_woocommerce_tracks_anon_id","woo:DBRhQ5oXitomqqKk5KsWPBXy"),
("50","1","wc_last_active","1700006400"),
("51","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("52","1","nav_menu_recently_edited","26"),
("53","1","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("54","3","nickname","Jenny Jaumann"),
("55","3","first_name","Jenny"),
("56","3","last_name","Jaumann"),
("57","3","description",""),
("58","3","rich_editing","true"),
("59","3","syntax_highlighting","true"),
("60","3","comment_shortcuts","false"),
("61","3","admin_color","fresh"),
("62","3","use_ssl","0"),
("63","3","show_admin_bar_front","true"),
("64","3","locale",""),
("65","3","dlhwp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("66","3","dlhwp_user_level","10"),
("67","3","dismissed_wp_pointers",""),
("68","3","default_password_nag",""),
("70","3","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.17.3\";}}}"),
("71","3","dlhwp_dashboard_quick_press_last_post_id","307"),
("72","3","community-events-location","a:1:{s:2:\"ip\";s:11:\"95.90.242.0\";}"),
("73","3","elementor_introduction","a:3:{s:6:\"e-apps\";b:1;s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("74","2","default_password_nag",""),
("76","2","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.18.3\";}}}"),
("77","2","dlhwp_dashboard_quick_press_last_post_id","353"),
("78","2","community-events-location","a:1:{s:2:\"ip\";s:11:\"24.134.18.0\";}"),
("79","2","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:16:\"favorites-notice\";b:1;}"),
("80","2","dlhwp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2023-11-24T12:19:32.308Z\";}"),
("82","3","dlhwp_user-settings","libraryContent=browse"),
("83","3","dlhwp_user-settings-time","1700836135"),
("84","3","dlhwp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:14:\"featured-image\";}}s:9:\"_modified\";s:24:\"2023-11-24T14:29:09.036Z\";}"),
("85","3","dlhwp_elementor_connect_common_data","a:3:{s:9:\"client_id\";s:32:\"8jcVYHdxvS3rF7f5qe4MEyccB2aNMfD9\";s:11:\"auth_secret\";s:32:\"bIc6AyzxzjplgygxRgha96exJx1Jpq2e\";s:5:\"state\";s:12:\"PgRQrZyWl20I\";}"),
("86","1","session_tokens","a:1:{s:64:\"7f1a0b8f139cf4c81f8f4da33252dfda8e1f982eb77f4a538d946fd338a3afd9\";a:4:{s:10:\"expiration\";i:1702710937;s:2:\"ip\";s:13:\"24.134.18.101\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36\";s:5:\"login\";i:1702538137;}}"),
("88","2","dlhwp_user-settings","libraryContent=browse&editor=tinymce"),
("89","2","dlhwp_user-settings-time","1703159250"),
("90","2","session_tokens","a:1:{s:64:\"45249aaee2e1a33e4631f364799c57d238cb7173f7fe03a8b43d1e303f444b21\";a:4:{s:10:\"expiration\";i:1703326651;s:2:\"ip\";s:13:\"24.134.18.101\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1703153851;}}");

INSERT IGNORE INTO `dlhwp_actionscheduler_actions` VALUES 
("17","action_scheduler/migration_hook","complete","2023-11-15 12:41:57","2023-11-15 13:41:57","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700052117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700052117;}","1","1","2023-11-15 12:44:00","2023-11-15 13:44:00","0",NULL),
("18","woocommerce_cleanup_draft_orders","complete","2023-11-15 12:41:28","2023-11-15 13:41:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700052088;s:18:\"\0*\0first_timestamp\";i:1700052088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700052088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-15 12:41:29","2023-11-15 13:41:29","0",NULL),
("19","woocommerce_cleanup_draft_orders","pending","2023-11-16 12:41:29","2023-11-16 13:41:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700138489;s:18:\"\0*\0first_timestamp\";i:1700052088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700138489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("20","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2023-11-15 14:18:20","2023-11-15 15:18:20","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700057900;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700057900;}","3","1","2023-11-15 14:18:20","2023-11-15 15:18:20","0",NULL),
("21","action_scheduler/migration_hook","complete","2023-11-15 14:19:19","2023-11-15 15:19:19","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700057959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700057959;}","1","1","2023-11-15 17:59:06","2023-11-15 18:59:06","0",NULL),
("22","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2023-11-15 14:18:21","2023-11-15 15:18:21","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700057901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700057901;}","3","1","2023-11-15 17:59:06","2023-11-15 18:59:06","0",NULL);

INSERT IGNORE INTO `dlhwp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2",""),
("3","woocommerce-db-updates");

INSERT IGNORE INTO `dlhwp_actionscheduler_logs` VALUES 
("1","17","Aktion erstellt","2023-11-15 12:40:57","2023-11-15 13:40:57"),
("2","18","Aktion erstellt","2023-11-15 12:41:28","2023-11-15 13:41:28"),
("3","18","Aktion über Async Request gestartet","2023-11-15 12:41:29","2023-11-15 13:41:29"),
("4","18","Aktion über Async Request abgeschlossen","2023-11-15 12:41:29","2023-11-15 13:41:29"),
("5","19","Aktion erstellt","2023-11-15 12:41:29","2023-11-15 13:41:29"),
("6","17","Aktion über WP Cron gestartet","2023-11-15 12:44:00","2023-11-15 13:44:00"),
("7","17","Aktion über WP Cron abgeschlossen","2023-11-15 12:44:00","2023-11-15 13:44:00"),
("8","20","Aktion erstellt","2023-11-15 14:18:19","2023-11-15 15:18:19"),
("9","21","Aktion erstellt","2023-11-15 14:18:19","2023-11-15 15:18:19"),
("10","20","Aktion über WP Cron gestartet","2023-11-15 14:18:20","2023-11-15 15:18:20"),
("11","22","Aktion erstellt","2023-11-15 14:18:20","2023-11-15 15:18:20"),
("12","20","Aktion über WP Cron abgeschlossen","2023-11-15 14:18:20","2023-11-15 15:18:20"),
("13","22","Aktion über Async Request gestartet","2023-11-15 17:59:06","2023-11-15 18:59:06"),
("14","22","Aktion über Async Request abgeschlossen","2023-11-15 17:59:06","2023-11-15 18:59:06"),
("15","21","Aktion über Async Request gestartet","2023-11-15 17:59:06","2023-11-15 18:59:06"),
("16","21","Aktion über Async Request abgeschlossen","2023-11-15 17:59:06","2023-11-15 18:59:06");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("110","20231215_075931_dailylocal_lengauerhofde","b001bd860c7938b34083_20231215065931","-1","2023-12-15 06:59:31","unknown","{\n    \"ID\": 110,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231215_075931_dailylocal_lengauerhofde\",\n    \"Hash\": \"b001bd860c7938b34083_20231215065931\",\n    \"NameHash\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_scan.json\",\n    \"timer_start\": 1702623572.737949,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 224015711,\n        \"Dirs\": [],\n        \"DirCount\": 2452,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13119,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"DKW4qrEtx09FYnAu0A\\/Y847WVgFY9PWBM0xlSG+qVing77ZmK9IybQqhRLPq7KWZwJr1jY1tyG2SkL4qYPExvw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3569,\n            \"tablesSizeOnDisk\": 12894208,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 147456\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"437\",\n                    \"insertedRows\": 466,\n                    \"size\": 1654784\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2598,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 311,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6205608,\n        \"File\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-15 06:59:31\",\n    \"updated\": \"2023-12-15 06:59:46\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-15 06:59:46"),
("111","20231215_075931_dailyonedirve_lengauerho","51352e16d2e767f08062_20231215065931","-2","2023-12-15 06:59:31","Corinna","{\n    \"ID\": 111,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231215_075931_dailyonedirve_lengauerho\",\n    \"Hash\": \"51352e16d2e767f08062_20231215065931\",\n    \"NameHash\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_scan.json\",\n    \"timer_start\": 1702623590.220249,\n    \"Runtime\": \"8.707 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.43MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97967185,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13119,\n        \"file_count\": 15571,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"zDbUkYvrfTD9PoEfPJFPxwK1k3dv\\/vBzb\\/s0EcgDvBm7OzZSkIgfcOLUx1XQDrEyY7R0vRuF17WF9iKPO+sT7A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3569,\n            \"tablesSizeOnDisk\": 12894208,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 147456\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"437\",\n                    \"insertedRows\": 450,\n                    \"size\": 1654784\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2598,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 311,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6049319,\n        \"File\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-15 06:59:31\",\n    \"updated\": \"2023-12-15 13:52:02\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-15 13:52:02"),
("113","20231216_050304_dailyonedirve_lengauerho","c6212429ff3b7ec45794_20231216040304","-2","2023-12-16 04:03:04","unknown","{\n    \"ID\": 113,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231216_050304_dailyonedirve_lengauerho\",\n    \"Hash\": \"c6212429ff3b7ec45794_20231216040304\",\n    \"NameHash\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_scan.json\",\n    \"timer_start\": 1702699385.896486,\n    \"Runtime\": \"10.571 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97984174,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"O\\/26lPcYJAGG8W2G0\\/ouI7+oO9dOQCP+a2ghpx1QOtzeMZRZAM3+BvE2\\/0P8yXUPsDK3IkPdzNAlYPV6HKuJOw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3581,\n            \"tablesSizeOnDisk\": 12976128,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 5,\n                    \"size\": 245760\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"443\",\n                    \"insertedRows\": 449,\n                    \"size\": 1638400\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2427,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 287,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6093450,\n        \"File\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-16 04:03:04\",\n    \"updated\": \"2023-12-16 08:14:40\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-16 08:14:40"),
("115","20231217_053042_dailyonedirve_lengauerho","9c746724402a1d808639_20231217043042","-2","2023-12-17 04:30:42","unknown","{\n    \"ID\": 115,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231217_053042_dailyonedirve_lengauerho\",\n    \"Hash\": \"9c746724402a1d808639_20231217043042\",\n    \"NameHash\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_scan.json\",\n    \"timer_start\": 1702787443.921922,\n    \"Runtime\": \"9.407 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97975586,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"DGlDBfNzG+AfU+xZFVTJRv79q0BrygSRfFvLSc7\\/OMWVvG3YpPszp0DvYeUZWYjYmp56tjeMYsUDqLrtXijGRQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3584,\n            \"tablesSizeOnDisk\": 14123008,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 344064\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"443\",\n                    \"insertedRows\": 447,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2427,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 287,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6084756,\n        \"File\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-17 04:30:42\",\n    \"updated\": \"2023-12-17 06:03:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-17 06:03:03"),
("117","20231218_040157_dailyonedirve_lengauerho","e30da44f5e8dc4c29977_20231218030157","-2","2023-12-18 03:01:57","unknown","{\n    \"ID\": 117,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231218_040157_dailyonedirve_lengauerho\",\n    \"Hash\": \"e30da44f5e8dc4c29977_20231218030157\",\n    \"NameHash\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_scan.json\",\n    \"timer_start\": 1702868519.082406,\n    \"Runtime\": \"9.822 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.45MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97985024,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"WXAYlNjHosZ9q7HxXafz6z4RtW\\/XU8FW2as+n1E\\/mhO7sYuAW+2+lX04Vf+D+UfjQWW6KM1SsIDM2qJLtVFdpQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3584,\n            \"tablesSizeOnDisk\": 14123008,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 9,\n                    \"size\": 344064\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"443\",\n                    \"insertedRows\": 449,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6166006,\n        \"File\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-18 03:01:57\",\n    \"updated\": \"2023-12-18 04:37:39\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-18 04:37:39"),
("119","20231219_084639_dailyonedirve_lengauerho","568f10695d1cb58d5555_20231219074639","-2","2023-12-19 07:46:39","unknown","{\n    \"ID\": 119,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231219_084639_dailyonedirve_lengauerho\",\n    \"Hash\": \"568f10695d1cb58d5555_20231219074639\",\n    \"NameHash\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_scan.json\",\n    \"timer_start\": 1702972019.228792,\n    \"Runtime\": \"8.995 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97977565,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"E2yJVaqluk7E4kuNdZJZwnMFRlDyWDjnBgPI9JLBzoEOLsV00c+bs8koQnY8hhlzRguXDL9JdC2Hdz72ft0Iyg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3590,\n            \"tablesSizeOnDisk\": 14221312,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 442368\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 448,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6160655,\n        \"File\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-19 07:46:39\",\n    \"updated\": \"2023-12-19 09:17:00\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-19 09:17:00");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("121","20231220_115359_dailyonedirve_lengauerho","a1346a572717a2d49381_20231220105359","-2","2023-12-20 10:53:59","unknown","{\n    \"ID\": 121,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231220_115359_dailyonedirve_lengauerho\",\n    \"Hash\": \"a1346a572717a2d49381_20231220105359\",\n    \"NameHash\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_scan.json\",\n    \"timer_start\": 1703069657.652264,\n    \"Runtime\": \"8.574 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.45MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97987696,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"P5MxmfPhBYUzzsNAvj3SQ3+c44EbPLdXuqMYHHPisIV1Sh6S612Sn5ZcdasdS4QttwISeGxortHe2jYMKTTnyw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3592,\n            \"tablesSizeOnDisk\": 15269888,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 450,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6262165,\n        \"File\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-20 10:53:59\",\n    \"updated\": \"2023-12-21 10:17:21\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-21 10:17:21"),
("122","20231221_111721_dailylocal_lengauerhofde","e703cc0b0c5cd5354184_20231221101721","-1","2023-12-21 10:17:21","unknown","{\n    \"ID\": 122,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231221_111721_dailylocal_lengauerhofde\",\n    \"Hash\": \"e703cc0b0c5cd5354184_20231221101721\",\n    \"NameHash\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_scan.json\",\n    \"timer_start\": 1703153843.804641,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 224053613,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Cb8fxZDKBSVkEihI3B6Vg580WhZMT3miaPQzrWhhJIMIF8J87R814rt7tx0egElgeNAP8fHvLzC936npiKOe\\/w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3592,\n            \"tablesSizeOnDisk\": 15269888,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 15,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 449,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6292220,\n        \"File\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-21 10:17:21\",\n    \"updated\": \"2023-12-21 10:17:37\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-21 10:17:37"),
("123","20231221_111722_dailyonedirve_lengauerho","09b2bbbfccc6ed2a6238_20231221101722","-2","2023-12-21 10:17:22","Corinna","{\n    \"ID\": 123,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231221_111722_dailyonedirve_lengauerho\",\n    \"Hash\": \"09b2bbbfccc6ed2a6238_20231221101722\",\n    \"NameHash\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_scan.json\",\n    \"timer_start\": 1703153858.807954,\n    \"Runtime\": \"8.810 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97978433,\n        \"Dirs\": [],\n        \"DirCount\": 2452,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13115,\n        \"file_count\": 15568,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"t02PiMJZjGgqWy7bxHKxxgbyC+Z5nzzaIMCmP6M+9yylkFWHHP5MkrMQiyz2iojED0+rT7fgpnO8cUl83LdS3g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3592,\n            \"tablesSizeOnDisk\": 15269888,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 15,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 458,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2364,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 277,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6372728,\n        \"File\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-21 10:17:22\",\n    \"updated\": \"2023-12-21 11:47:54\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-21 11:47:54"),
("124","20231222_051800_dailylocal_lengauerhofde","32a7a58eb9be03f09248_20231222041800","-2","2023-12-22 04:18:00","unknown","{\n    \"ID\": 124,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231222_051800_dailylocal_lengauerhofde\",\n    \"Hash\": \"32a7a58eb9be03f09248_20231222041800\",\n    \"NameHash\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_scan.json\",\n    \"timer_start\": 1703218682.32059,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 296969361,\n        \"Dirs\": [],\n        \"DirCount\": 2452,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13182,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"WzPczj3h1dDlDj+WIxMQSRxI53j283F0\\/DwwzWZJOBQxTQZbmMi0jVIDLu4bUsi4zK9pce69wOKhLAlzAaY3yQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3692,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 467,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 304,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7568391,\n        \"File\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-22 04:18:00\",\n    \"updated\": \"2023-12-23 06:05:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-23 06:05:59"),
("125","20231222_051800_dailyonedirve_lengauerho","04acf8b74060a3fc3729_20231222041800","-2","2023-12-22 04:18:00","unknown","{\n    \"ID\": 125,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231222_051800_dailyonedirve_lengauerho\",\n    \"Hash\": \"04acf8b74060a3fc3729_20231222041800\",\n    \"NameHash\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_scan.json\",\n    \"timer_start\": 1703311561.724161,\n    \"Runtime\": \"18.233 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.51MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170407110,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13182,\n        \"file_count\": 15634,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"kiWhulBHaSuAOg1sJE1nD4D2iEJEgQoVN4w3ARnRPvX585DTfyLFUBfcH5dEKOVnQLg+cQPBL0Q9Sme7neWntQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2526\",\n                    \"insertedRows\": 2548,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6764285,\n        \"File\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-22 04:18:00\",\n    \"updated\": \"2023-12-23 23:18:53\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-23 23:18:53"),
("127","20231223_070559_dailyonedirve_lengauerho","96791c0ef57a61fc2836_20231223060559","-2","2023-12-23 06:05:59","unknown","{\n    \"ID\": 127,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231223_070559_dailyonedirve_lengauerho\",\n    \"Hash\": \"96791c0ef57a61fc2836_20231223060559\",\n    \"NameHash\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_scan.json\",\n    \"timer_start\": 1703373550.251852,\n    \"Runtime\": \"10.681 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.5MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170394847,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"6c7g7khz9\\/dy773CbBDGycWMKv9TlwzwkguKTLNRvk1o+GDHlHHt8uwxOGPpL0rPt7QIRrkjEXF5PbjyPC+keg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2526\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6628369,\n        \"File\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-23 06:05:59\",\n    \"updated\": \"2023-12-24 09:15:49\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-24 09:15:49");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("129","20231224_101549_dailyonedirve_lengauerho","775e70eecb47802b7392_20231224091549","-2","2023-12-24 09:15:49","unknown","{\n    \"ID\": 129,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231224_101549_dailyonedirve_lengauerho\",\n    \"Hash\": \"775e70eecb47802b7392_20231224091549\",\n    \"NameHash\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_scan.json\",\n    \"timer_start\": 1703409367.377978,\n    \"Runtime\": \"10.809 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170442457,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"D0iTKH2r73MahnE6ruIcZvft70iipqUUezBe4vnx2demL8RD5bYThp4yJZLHFcHI9peno9fxNC1mwx7XdrPfZw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"453\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6900236,\n        \"File\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-24 09:15:49\",\n    \"updated\": \"2023-12-24 22:02:27\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-24 22:02:27"),
("131","20231226_041132_dailyonedirve_lengauerho","1e6d0962d919bdb82735_20231226031132","-2","2023-12-26 03:11:32","unknown","{\n    \"ID\": 131,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231226_041132_dailyonedirve_lengauerho\",\n    \"Hash\": \"1e6d0962d919bdb82735_20231226031132\",\n    \"NameHash\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_scan.json\",\n    \"timer_start\": 1703560313.495667,\n    \"Runtime\": \"10.976 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170442516,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"YDS9Bwya46pDsAPOLwkkiFpKMHtv3byb+asKMIzVm93hljeXllKPCQMU1HtVq4JI\\/gHozPEvGHZCJqo2IGeDcQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3694,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 23,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"452\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6945368,\n        \"File\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-26 03:11:32\",\n    \"updated\": \"2023-12-26 07:43:43\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-26 07:43:43"),
("133","20231227_061431_dailyonedirve_lengauerho","67b8a488d1cbb48c6991_20231227051431","-2","2023-12-27 05:14:31","unknown","{\n    \"ID\": 133,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231227_061431_dailyonedirve_lengauerho\",\n    \"Hash\": \"67b8a488d1cbb48c6991_20231227051431\",\n    \"NameHash\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_scan.json\",\n    \"timer_start\": 1703654093.613802,\n    \"Runtime\": \"10.588 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170444436,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"q\\/ds\\/y5rKps8IdAWW2JR\\/FxFXdDma7NEZRQlGvMZA7RUJDS8Lb5L4I\\/GSybHuAA0SwuR\\/YQfdAE3uSo3IE5iZg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3700,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 24,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6970803,\n        \"File\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-27 05:14:31\",\n    \"updated\": \"2023-12-27 23:57:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-27 23:57:17"),
("134","20231228_032918_dailylocal_lengauerhofde","5cc46fd835c0f5337180_20231228022918","100","2023-12-28 02:29:18","unknown","{\n    \"ID\": 134,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231228_032918_dailylocal_lengauerhofde\",\n    \"Hash\": \"5cc46fd835c0f5337180_20231228022918\",\n    \"NameHash\": \"20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918_scan.json\",\n    \"timer_start\": 1703730560.682999,\n    \"Runtime\": \"16.427 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170453303,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"332ckdh\\/pGGseQ\\/PE0sYnD51Jc3yFYwK7QQDJ0UiaprvGWI98Yqk6HgosTGnrKZsfmhTE3dH32+nc1OILNFTRQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3700,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7046735,\n        \"File\": \"20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1703730577,\n            \"stopped_timestamp\": 1703730577,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-28 02:29:18\",\n    \"updated\": \"2023-12-28 02:29:37\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231228_032918_dailylocal_lengauerhofde_5cc46fd835c0f5337180_20231228022918_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2023-12-28 02:29:37"),
("135","20231228_042354_dailyonedirve_lengauerho","94e70ff93c5569792193_20231228032354","-2","2023-12-28 03:23:54","unknown","{\n    \"ID\": 135,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231228_042354_dailyonedirve_lengauerho\",\n    \"Hash\": \"94e70ff93c5569792193_20231228032354\",\n    \"NameHash\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_scan.json\",\n    \"timer_start\": 1703733835.110167,\n    \"Runtime\": \"12.446 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170453228,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"H8H+ONkGXc49Gotw\\/q+URHtANCz1Z2TcokrJJciXhgvpBRh2lT9D062aTamLPC3RfYmDApLWech4sZ9p9VtmSg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3700,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7046768,\n        \"File\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-28 03:23:54\",\n    \"updated\": \"2023-12-28 04:57:52\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-28 04:57:52"),
("136","20231229_030037_dailylocal_lengauerhofde","43638cd5b40844956370_20231229020037","100","2023-12-29 02:00:37","unknown","{\n    \"ID\": 136,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231229_030037_dailylocal_lengauerhofde\",\n    \"Hash\": \"43638cd5b40844956370_20231229020037\",\n    \"NameHash\": \"20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037_scan.json\",\n    \"timer_start\": 1703815239.016607,\n    \"Runtime\": \"15.369 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170453654,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"qnE+fT0+lX5y04A9CoSuUtGs2gvdqX0U7II7Gbeud8RmsbCgdBY6rKY9YsaB\\/JYozyhMPBxkeICDXfZzvann2w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15843328,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 1425408\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7071676,\n        \"File\": \"20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1703815254,\n            \"stopped_timestamp\": 1703815254,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-29 02:00:37\",\n    \"updated\": \"2023-12-29 02:00:54\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231229_030037_dailylocal_lengauerhofde_43638cd5b40844956370_20231229020037_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2023-12-29 02:00:54");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("137","20231229_040634_dailyonedirve_lengauerho","a587455abfc76c624533_20231229030634","-2","2023-12-29 03:06:34","unknown","{\n    \"ID\": 137,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231229_040634_dailyonedirve_lengauerho\",\n    \"Hash\": \"a587455abfc76c624533_20231229030634\",\n    \"NameHash\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_scan.json\",\n    \"timer_start\": 1703819195.110742,\n    \"Runtime\": \"11.808 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170453581,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"4nCFtBs50LA+nuxogBc0g+VQQPmWkQeLGossN0bRT0kCe7z8eQSDzGCe0ktIcdoIJcxa6nmvU4S9fy89UQergw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15843328,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 1425408\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7071709,\n        \"File\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-29 03:06:34\",\n    \"updated\": \"2023-12-29 04:38:32\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-29 04:38:32"),
("138","20231230_034826_dailylocal_lengauerhofde","ae7ce5102884f4404943_20231230024826","100","2023-12-30 02:48:26","unknown","{\n    \"ID\": 138,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231230_034826_dailylocal_lengauerhofde\",\n    \"Hash\": \"ae7ce5102884f4404943_20231230024826\",\n    \"NameHash\": \"20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826_scan.json\",\n    \"timer_start\": 1703904507.923901,\n    \"Runtime\": \"17.436 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170445466,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"7OfDaBcQYJs\\/Outt54xm4\\/kbrWc4smDfdrTRHL9YSva0sCMnFS75vVYRB+cjFLO35la5T006rwRhoW4oBXbh2A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3684,\n            \"tablesSizeOnDisk\": 15810560,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 27,\n                    \"size\": 1392640\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7041462,\n        \"File\": \"20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1703904525,\n            \"stopped_timestamp\": 1703904525,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-30 02:48:26\",\n    \"updated\": \"2023-12-30 02:48:45\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231230_034826_dailylocal_lengauerhofde_ae7ce5102884f4404943_20231230024826_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2023-12-30 02:48:45"),
("139","20231230_040058_dailyonedirve_lengauerho","d4e53a0f17b9cd791351_20231230030058","-2","2023-12-30 03:00:58","unknown","{\n    \"ID\": 139,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231230_040058_dailyonedirve_lengauerho\",\n    \"Hash\": \"d4e53a0f17b9cd791351_20231230030058\",\n    \"NameHash\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_scan.json\",\n    \"timer_start\": 1703905259.45322,\n    \"Runtime\": \"11.630 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170454260,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"cN+jhRTgAO+omYHR4UJ8xKqlNeKwLIu85m3mKLOY+RAVaHxcrjD7V+ttp\\/0YN1wQdOCQxiTaqsmhhlu+XNQWQA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3684,\n            \"tablesSizeOnDisk\": 15810560,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 27,\n                    \"size\": 1392640\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7095660,\n        \"File\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-30 03:00:58\",\n    \"updated\": \"2023-12-30 04:36:36\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-30 04:36:36"),
("140","20231231_053936_dailylocal_lengauerhofde","e5e1abda58965a6d5639_20231231043936","100","2023-12-31 04:39:36","unknown","{\n    \"ID\": 140,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231231_053936_dailylocal_lengauerhofde\",\n    \"Hash\": \"e5e1abda58965a6d5639_20231231043936\",\n    \"NameHash\": \"20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936_scan.json\",\n    \"timer_start\": 1703997578.716857,\n    \"Runtime\": \"17.072 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170455789,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"x4KwMbjWqTwpNaN5jWGUO\\/5FODL6plz4KWmQpbaqRr9MLcwAzHgagSicamIa7h9EyEcyiGl87HcuORf2GGTU8w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3686,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 29,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7126224,\n        \"File\": \"20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1703997595,\n            \"stopped_timestamp\": 1703997596,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:39:36\",\n    \"updated\": \"2023-12-31 04:39:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231231_053936_dailylocal_lengauerhofde_e5e1abda58965a6d5639_20231231043936_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2023-12-31 04:39:56"),
("141","20231231_053936_dailyonedirve_lengauerho","d005caa630df8b1d7502_20231231043936","-2","2023-12-31 04:39:36","unknown","{\n    \"ID\": 141,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231231_053936_dailyonedirve_lengauerho\",\n    \"Hash\": \"d005caa630df8b1d7502_20231231043936\",\n    \"NameHash\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_scan.json\",\n    \"timer_start\": 1703997596.892447,\n    \"Runtime\": \"10.568 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170454898,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"XLwtJdMRpyjPb8jMie2s5J5xSNR22giO4IpEN8seUyt60ga8xPRyxubC4\\/qX0N1XyckjHvzIgdiEcBpbQrVBrg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3686,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 28,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7119340,\n        \"File\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:39:36\",\n    \"updated\": \"2023-12-31 06:18:23\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-31 06:18:23"),
("142","20240102_054232_dailylocal_lengauerhofde","7008d4b9e0441d7e2140_20240102044232","100","2024-01-02 04:42:32","unknown","{\n    \"ID\": 142,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240102_054232_dailylocal_lengauerhofde\",\n    \"Hash\": \"7008d4b9e0441d7e2140_20240102044232\",\n    \"NameHash\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_scan.json\",\n    \"timer_start\": 1704170554.502641,\n    \"Runtime\": \"15.921 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170447521,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"JHx3pOLQolBKMiT8w6mQQde6DfQziv\\/EQS99mAvbqclyZvxErT1l0VEgCVkJgcUPvdaS0lF0ctxiEhBvj\\/G\\/QQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3689,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7095320,\n        \"File\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704170570,\n            \"stopped_timestamp\": 1704170570,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-02 04:42:32\",\n    \"updated\": \"2024-01-02 04:42:50\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-02 04:42:50");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("143","20240102_054232_dailyonedirve_lengauerho","d2f912c1400693ad7682_20240102044232","-2","2024-01-02 04:42:32","unknown","{\n    \"ID\": 143,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240102_054232_dailyonedirve_lengauerho\",\n    \"Hash\": \"d2f912c1400693ad7682_20240102044232\",\n    \"NameHash\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_scan.json\",\n    \"timer_start\": 1704170571.545595,\n    \"Runtime\": \"10.540 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170446141,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"DKdjj76Fh2IMmGOuprR03toiEsEPvAd8TCWmCg9NR4v3GMwX5N\\/ORG4sDPN27N0lRf5uX4vDJaE8xJnRc3kFxg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3689,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 29,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7088438,\n        \"File\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-02 04:42:32\",\n    \"updated\": \"2024-01-02 07:29:40\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-02 07:29:40"),
("144","20240103_160024_dailylocal_lengauerhofde","536054ee48b3e3815140_20240103150024","100","2024-01-03 15:00:24","unknown","{\n    \"ID\": 144,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240103_160024_dailylocal_lengauerhofde\",\n    \"Hash\": \"536054ee48b3e3815140_20240103150024\",\n    \"NameHash\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_scan.json\",\n    \"timer_start\": 1704294026.888295,\n    \"Runtime\": \"17.178 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170447947,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"UVAE4zIsfdik6c6wQPir\\/jnMoqInvbVwBam4VM1yyj2Glkde8227hA+d1gImxxGROnZ0TseUawtT7xuCJFjimA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3692,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7119926,\n        \"File\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704294044,\n            \"stopped_timestamp\": 1704294044,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-03 15:00:24\",\n    \"updated\": \"2024-01-03 15:00:44\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-03 15:00:44"),
("145","20240103_160024_dailyonedirve_lengauerho","dc72d38063211d348944_20240103150024","-2","2024-01-03 15:00:24","unknown","{\n    \"ID\": 145,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240103_160024_dailyonedirve_lengauerho\",\n    \"Hash\": \"dc72d38063211d348944_20240103150024\",\n    \"NameHash\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_scan.json\",\n    \"timer_start\": 1704294045.254729,\n    \"Runtime\": \"11.182 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170448110,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"5wBhjsTH+oNGdER9IGNwa\\/\\/DWDj237QXmLRFRwMtMxDt\\/G9l3+zvJoN8jgpoErCFoac96+NSUz\\/VgE1kVx\\/+8A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3692,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7137573,\n        \"File\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-03 15:00:24\",\n    \"updated\": \"2024-01-03 16:56:06\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-03 16:56:06"),
("146","20240105_083340_dailylocal_lengauerhofde","72b5027acc5e7f8f8564_20240105073340","100","2024-01-05 07:33:40","unknown","{\n    \"ID\": 146,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240105_083340_dailylocal_lengauerhofde\",\n    \"Hash\": \"72b5027acc5e7f8f8564_20240105073340\",\n    \"NameHash\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_scan.json\",\n    \"timer_start\": 1704440021.95278,\n    \"Runtime\": \"21.078 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170451329,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"pMi4KQcGxSH94SOJ0G2JRGG1zmAKLWIu8G\\/ITfmyvj7FHZVff8\\/PJdc8x3+SVQHX4dgRhzJ2O1gvcqS7YIO1JA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3694,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7168376,\n        \"File\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704440043,\n            \"stopped_timestamp\": 1704440043,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-05 07:33:40\",\n    \"updated\": \"2024-01-05 07:34:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-05 07:34:03"),
("147","20240105_083340_dailyonedirve_lengauerho","9b7d90243e47e4694602_20240105073340","-2","2024-01-05 07:33:40","unknown","{\n    \"ID\": 147,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240105_083340_dailyonedirve_lengauerho\",\n    \"Hash\": \"9b7d90243e47e4694602_20240105073340\",\n    \"NameHash\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_scan.json\",\n    \"timer_start\": 1704440044.382361,\n    \"Runtime\": \"10.766 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170460311,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8mqgpdE0T4pXsOeCqY2c+RiAfI\\/xzPllisE+\\/UzDPYcEL1tzu6sgAU2Ucg3hT0bAYPoc9zMBJLkkMt+31Phl8Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3694,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 32,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7216052,\n        \"File\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-05 07:33:40\",\n    \"updated\": \"2024-01-05 15:49:15\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-05 15:49:15"),
("148","20240106_145825_dailylocal_lengauerhofde","d0439d9f55a63b0b4006_20240106135825","100","2024-01-06 13:58:25","unknown","{\n    \"ID\": 148,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240106_145825_dailylocal_lengauerhofde\",\n    \"Hash\": \"d0439d9f55a63b0b4006_20240106135825\",\n    \"NameHash\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_scan.json\",\n    \"timer_start\": 1704549507.416855,\n    \"Runtime\": \"17.267 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170452125,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8bLelBWqleKKBR2Y\\/Zu5l71KPcMn1cyh9GG7dWS\\/or3JvF6x1VRLBJUj2+XCPVReWKrTsbD3U5kHnTs55V3+Cg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 34,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7192433,\n        \"File\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704549524,\n            \"stopped_timestamp\": 1704549524,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-06 13:58:25\",\n    \"updated\": \"2024-01-06 13:58:45\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-06 13:58:45");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("149","20240106_145825_dailyonedirve_lengauerho","b843fa9f6af5c1b89337_20240106135825","-2","2024-01-06 13:58:25","unknown","{\n    \"ID\": 149,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240106_145825_dailyonedirve_lengauerho\",\n    \"Hash\": \"b843fa9f6af5c1b89337_20240106135825\",\n    \"NameHash\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_scan.json\",\n    \"timer_start\": 1704549525.883232,\n    \"Runtime\": \"10.676 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170451274,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"M2KiNsHcg0aciKY9bp5UgHEHQ2Wa8VYANoxnhxSkvajemISz\\/YZWYfFu\\/vnNAcNKwp5QiN8k9g+2qXruBnd5Yw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 33,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7185537,\n        \"File\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-06 13:58:25\",\n    \"updated\": \"2024-01-06 18:16:41\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-06 18:16:41"),
("150","20240107_055511_dailylocal_lengauerhofde","95f99d700eb42bde6327_20240107045511","100","2024-01-07 04:55:11","unknown","{\n    \"ID\": 150,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240107_055511_dailylocal_lengauerhofde\",\n    \"Hash\": \"95f99d700eb42bde6327_20240107045511\",\n    \"NameHash\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_scan.json\",\n    \"timer_start\": 1704603313.556013,\n    \"Runtime\": \"18.655 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170450118,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"C8+dh+ejNZlEV2UWtAZ8PZQqR3G5O5tzyIEEofkU1MiNJY51QHmS2C0FxDRgYpz3vatd4Gihypzb2bAU9SYyuQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 35,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7213901,\n        \"File\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704603332,\n            \"stopped_timestamp\": 1704603332,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-07 04:55:11\",\n    \"updated\": \"2024-01-07 04:55:32\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-07 04:55:32"),
("151","20240107_055511_dailyonedirve_lengauerho","c9fb6ebe56e13ef69650_20240107045511","-2","2024-01-07 04:55:11","unknown","{\n    \"ID\": 151,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240107_055511_dailyonedirve_lengauerho\",\n    \"Hash\": \"c9fb6ebe56e13ef69650_20240107045511\",\n    \"NameHash\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_scan.json\",\n    \"timer_start\": 1704603333.466552,\n    \"Runtime\": \"10.654 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170451277,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"0RKGAMcagQRSlRiO6VkFHv5ACgUzLl4UyVIjmpemoUxIfKewbJJHpY5q5NBhvy714FXCPdbvItWKzr3m4B2uww==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 34,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7207014,\n        \"File\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-07 04:55:11\",\n    \"updated\": \"2024-01-07 06:55:16\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-07 06:55:16"),
("152","20240108_050913_dailylocal_lengauerhofde","d2183b30be9f900c2532_20240108040913","100","2024-01-08 04:09:13","unknown","{\n    \"ID\": 152,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240108_050913_dailylocal_lengauerhofde\",\n    \"Hash\": \"d2183b30be9f900c2532_20240108040913\",\n    \"NameHash\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_scan.json\",\n    \"timer_start\": 1704686955.507737,\n    \"Runtime\": \"18.012 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170460028,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"N24dQJ3Dogml72SmB8sk+c\\/6QUVlzC\\/HUrbSdZPTyKne\\/vjGsCxAeYlWI\\/wN8R+Yy47JOYEAWRyymThV2jKPDg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7291729,\n        \"File\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704686973,\n            \"stopped_timestamp\": 1704686973,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-08 04:09:13\",\n    \"updated\": \"2024-01-08 04:09:33\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-08 04:09:33"),
("153","20240108_050913_dailyonedirve_lengauerho","6177162272cb7ddd7144_20240108040913","20","2024-01-08 04:09:13","unknown","{\n    \"ID\": 153,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240108_050913_dailyonedirve_lengauerho\",\n    \"Hash\": \"6177162272cb7ddd7144_20240108040913\",\n    \"NameHash\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_scan.json\",\n    \"timer_start\": 1704686974.751008,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 297245908,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"2bJOfkEFRKw6G+rTpNJCaiyrab2WjR5IzHNNIiT4DcisdSFbOxRq12C7yZAbLp+ttBsTd0IdJRT50lWMWkQv+g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 0,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 0,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 0,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 0,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 1704686975,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"dlhwp_users\",\n            \"dlhwp_usermeta\",\n            \"dlhwp_actionscheduler_actions\",\n            \"dlhwp_actionscheduler_claims\",\n            \"dlhwp_actionscheduler_groups\",\n            \"dlhwp_actionscheduler_logs\",\n            \"dlhwp_commentmeta\",\n            \"dlhwp_comments\",\n            \"dlhwp_duplicator_backups\",\n            \"dlhwp_duplicator_entities\",\n            \"dlhwp_e_events\",\n            \"dlhwp_e_notes\",\n            \"dlhwp_e_notes_users_relations\",\n            \"dlhwp_e_submissions\",\n            \"dlhwp_e_submissions_actions_log\",\n            \"dlhwp_e_submissions_values\",\n            \"dlhwp_links\",\n            \"dlhwp_options\",\n            \"dlhwp_postmeta\",\n            \"dlhwp_posts\",\n            \"dlhwp_term_relationships\",\n            \"dlhwp_term_taxonomy\",\n            \"dlhwp_termmeta\",\n            \"dlhwp_terms\",\n            \"dlhwp_wc_admin_note_actions\",\n            \"dlhwp_wc_admin_notes\",\n            \"dlhwp_wc_category_lookup\",\n            \"dlhwp_wc_customer_lookup\",\n            \"dlhwp_wc_download_log\",\n            \"dlhwp_wc_order_addresses\",\n            \"dlhwp_wc_order_coupon_lookup\",\n            \"dlhwp_wc_order_operational_data\",\n            \"dlhwp_wc_order_product_lookup\",\n            \"dlhwp_wc_order_stats\",\n            \"dlhwp_wc_order_tax_lookup\",\n            \"dlhwp_wc_orders\",\n            \"dlhwp_wc_orders_meta\",\n            \"dlhwp_wc_product_attributes_lookup\",\n            \"dlhwp_wc_product_download_directories\",\n            \"dlhwp_wc_product_meta_lookup\",\n            \"dlhwp_wc_rate_limits\",\n            \"dlhwp_wc_reserved_stock\",\n            \"dlhwp_wc_tax_rate_classes\",\n            \"dlhwp_wc_webhooks\",\n            \"dlhwp_woocommerce_api_keys\",\n            \"dlhwp_woocommerce_attribute_taxonomies\",\n            \"dlhwp_woocommerce_downloadable_product_permissions\",\n            \"dlhwp_woocommerce_log\",\n            \"dlhwp_woocommerce_order_itemmeta\",\n            \"dlhwp_woocommerce_order_items\",\n            \"dlhwp_woocommerce_payment_tokenmeta\",\n            \"dlhwp_woocommerce_payment_tokens\",\n            \"dlhwp_woocommerce_sessions\",\n            \"dlhwp_woocommerce_shipping_zone_locations\",\n            \"dlhwp_woocommerce_shipping_zone_methods\",\n            \"dlhwp_woocommerce_shipping_zones\",\n            \"dlhwp_woocommerce_tax_rate_locations\",\n            \"dlhwp_woocommerce_tax_rates\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1704686974.78671,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 3695,\n            \"tables\": {\n                \"dlhwp_users\": {\n                    \"start\": \"3\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-08 04:09:13\",\n    \"updated\": \"2024-01-08 04:09:35\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_archive.zip","20","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-08 04:09:35");

INSERT IGNORE INTO `dlhwp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"michael@zahlenwerk21.de\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"michael@zahlenwerk21.de\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/dev\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"local_upload_chunksize_in_MB\": 16,\n    \"manual_mode_storage_ids\": [\n        10\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1704915034,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_type\": \"2\",\n    \"license_limit\": 15,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1690481069,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-01-03 19:30:34\"\n}","","","","","","4.5.14.2","0000-00-00 00:00:00","2024-01-03 19:30:34"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2023-12-14 07:19:07\"\n}","","","","","","4.5.14.2","0000-00-00 00:00:00","2023-12-14 07:19:07"),
("3","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"roYS8h8v3nbEOdDRjKg0uNjG4IOyZED\\/wEKc9KUnFfLkg3pmWpoFKwTWVtBO5bhoHA0AV\\/8+AS3YFwHYCA2GlQ==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 3\n}","","","","","","","0000-00-00 00:00:00","2023-11-16 14:39:37"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"k4HJ\\/tTgJb7aiXW7mI1kibGNpfZxpnWolbG5EIwv17JytKHoQ0B85Ympv\\/OTf3e3EgB6veJZDprJRrCRVFCqvQ==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 4\n}","","","","","","","0000-00-00 00:00:00","2023-11-16 14:39:37"),
("5","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1704686972,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-01-08 04:09:33\"\n}","","","","","","4.5.14.2","0000-00-00 00:00:00","2024-01-08 04:09:33"),
("9","DUP_PRO_Storage_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"TqBEZMC+fKnyY01R\\/Ui3TNphxKQxBxcXtjqvHxIpmr4TAfq2GKQ8\\/IH6fref1xpu9k4lWLRFrRF9DbDWIsC+cXYVbp99YrINTt\\/JhLTJ72gFz7gJF4CErIGGJRGAMdhjifzpQs4Dyi00duBHy5yRUoXtZTHM1+k7pmtxqzbslKOHNG7XQdq4RV93U4JbGtB9HI+\\/92S49QgR8oJG+Gkl\\/QLho4olvsjeeg0LAjZsfZ5fc6qtagY2HD9yuIdtQLs3hHR7litLXkcu8xtZM363dp2KQ387S3gfRJOchEoRDxCuEgT8PdQZSQ==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-11-16 13:39:39\",\n    \"updated\": \"2023-12-14 07:16:31\"\n}","","","","","","4.5.14.2","2023-11-16 13:39:39","2023-12-14 07:16:31"),
("11","EmailSummary","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": {\n        \"14\": [\n            142,\n            144,\n            146,\n            148,\n            150,\n            152\n        ],\n        \"15\": [\n            143,\n            145,\n            147,\n            149,\n            151\n        ]\n    },\n    \"failedPackageIds\": [\n        143,\n        145,\n        147,\n        149,\n        151\n    ],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"id\": 11,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-01-08 04:09:33\"\n}","","","","","","4.5.14.2","0000-00-00 00:00:00","2024-01-08 04:09:33"),
("13","DUP_PRO_Storage_Entity","{\n    \"name\": \"one drive\",\n    \"notes\": \"\",\n    \"storage_type\": 7,\n    \"config\": \"Mv84rmNK\\/Q7P8K\\/8FCGjP3aJEIc6aE38MfyKXE1MVPkTAfq2GKQ8\\/IH6fref1xpuGNkoULikJ7SjbGAx8hTu\\/jx6s07rBWNAVoiQynDhTAfHB7YXN33Umr76Y8wtLeIUgZBk5J3i8taCE5sLc4s1d96nQsRO7Aqe2B7X5FCHEKH09vMTlFNBqp5NFgGy\\/hDvJxHxffd\\/XeyKfEbZ9pDSbAspjddSPEjXX1Xb8jlQuFbVaH1\\/yBXPPTw9uIOWIAYi4LHLvj11Hy7rrG65xZiZLZU9aAQLgCQYkFugCz6kVjv\\/a7haaLTKV0QafClnGdSlN8PI5JqNH1KVcsahm6wp09DXlRo9c7Z7k9wvJcVJx\\/jjyaYoIv9qBwISMq\\/jSjeWUPsxLHUSYvCyttEuH32iDxLMdg+xEVeSxs9+dcjvv4aJREof\\/eOUkg==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 13,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-14 07:17:45\",\n    \"updated\": \"2023-12-14 07:17:45\"\n}","","","","","","4.5.14.2","2023-12-14 07:17:45","2023-12-14 07:17:45"),
("14","DUP_PRO_Schedule_Entity","{\n    \"name\": \"daily local\",\n    \"template_id\": 3,\n    \"start_ticks\": 1420081200,\n    \"repeat_type\": 0,\n    \"active\": true,\n    \"next_run_time\": 1704765600,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 1,\n    \"cron_string\": \"0 3 * * *\",\n    \"last_run_time\": 1704686973,\n    \"last_run_status\": 0,\n    \"times_run\": 24,\n    \"storage_ids\": [\n        9\n    ],\n    \"id\": 14,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-14 07:18:19\",\n    \"updated\": \"2024-01-08 04:09:33\"\n}","","","","","","4.5.14.2","2023-12-14 07:18:19","2024-01-08 04:09:33"),
("15","DUP_PRO_Schedule_Entity","{\n    \"name\": \"daily one dirve\",\n    \"template_id\": 3,\n    \"start_ticks\": 1420084800,\n    \"repeat_type\": 0,\n    \"active\": true,\n    \"next_run_time\": 1704769200,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 1,\n    \"cron_string\": \"0 4 * * *\",\n    \"last_run_time\": 1704610516,\n    \"last_run_status\": 1,\n    \"times_run\": 42,\n    \"storage_ids\": [\n        13\n    ],\n    \"id\": 15,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-14 07:18:36\",\n    \"updated\": \"2024-01-08 04:09:13\"\n}","","","","","","4.5.14.2","2023-12-14 07:18:36","2024-01-08 04:09:13");

INSERT IGNORE INTO `dlhwp_options` VALUES 
("1","siteurl","https://dev.lengauerhof.at/dev","yes"),
("2","home","https://dev.lengauerhof.at/dev","yes"),
("3","blogname","Lengauer Hof DEV","yes"),
("4","blogdescription","Das herzliche Kinderhotel für Aktive Familien und Freunde von purem Genuss.","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","michael@zahlenwerk21.de","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","j. F Y","yes"),
("24","time_format","G:i","yes"),
("25","links_updated_date_format","j. F Y G:i","yes"),
("26","comment_moderation","","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:109:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=90&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:5:{i:0;s:33:\"duplicator-pro/duplicator-pro.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:31:\"elementor-pro/elementor-pro.php\";i:3;s:33:\"duplicate-post/duplicate-post.php\";i:4;s:33:\"duplicator-pro/duplicator-pro.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","hello-elementor","yes"),
("41","stylesheet","hello-theme-child-master","yes"),
("42","comment_registration","","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","56657","yes"),
("47","uploads_use_yearmonth_folders","","yes"),
("48","upload_path","","yes"),
("49","blog_public","0","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","blank","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","no"),
("80","timezone_string","Europe/Berlin","yes"),
("81","page_for_posts","0","yes"),
("82","page_on_front","90","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","0","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1706032766","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:1:{s:33:\"duplicator-pro/duplicator-pro.php\";s:8:\"4.5.14.2\";}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","wp_force_deactivated_plugins","a:0:{}","yes"),
("99","initial_db_version","53496","yes"),
("100","dlhwp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:131:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}","yes"),
("101","fresh_site","0","yes"),
("102","WPLANG","de_DE","yes"),
("103","user_count","3","no"),
("104","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Neueste Beiträge</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:230:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Neueste Kommentare</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:145:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archive</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Kategorien</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes"),
("105","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","yes"),
("106","cron","a:21:{i:1704688856;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1704688895;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1704689945;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1704689968;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1704693568;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1704693577;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1704715145;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1704717655;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704717656;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704718800;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1704736755;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704736768;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704736777;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704736778;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704737043;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704747545;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704754800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704907392;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705021165;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705082368;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("122","theme_mods_twentytwentythree","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1690480909;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","yes"),
("123","recovery_keys","a:0:{}","yes"),
("124","https_detection_errors","a:0:{}","yes"),
("156","recently_activated","a:0:{}","yes"),
("159","finished_updating_comment_type","1","yes"),
("165","current_theme","Hello Elementor Child","yes"),
("166","theme_mods_hello-elementor","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1690481265;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}","yes"),
("167","theme_switched","","yes"),
("168","hello_theme_version","2.9.0","yes"),
("173","elementor_active_kit","17","yes"),
("174","elementor_font_display","swap","yes"),
("177","elementor_version","3.18.3","yes"),
("178","elementor_install_history","a:4:{s:6:\"3.14.1\";i:1690481019;s:6:\"3.17.3\";i:1700051678;s:6:\"3.18.2\";i:1702538129;s:6:\"3.18.3\";i:1703153851;}","yes"),
("179","elementor_events_db_version","1.0.0","no"),
("181","elementor_onboarded","1","yes"),
("182","elementor_connect_site_key","dfc38f26b0e8c8809a990a6ee3f02d5a","yes"),
("183","elementor_allow_tracking","yes","yes"),
("184","elementor_tracker_last_send","1704440028","yes"),
("187","_elementor_installed_time","1690480931","yes"),
("188","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_versio