/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-01-18 17:10:26 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `dlhwp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2989 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3549 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=362 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `dlhwp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `dlhwp_users` VALUES 
("1","Michael Albert","$P$BBoqs/UicPRjrC5XN0sJPZBC.X6wkL0","michael-albert","michael@zahlenwerk21.de","https://dev.lengauerhof.at/dev/dev","2023-07-27 17:59:28","","0","Michael Albert"),
("2","Corinna","$P$BuXy9J7rpR8SRZHhc9Hyyf2Kqq2X8e0","corinna","corinna@zahlenwerk21.de","","2023-11-15 12:36:43","","0","Corinna Charné"),
("3","Jenny Jaumann","$P$BFEA5i1u/R2iZv3sO5y5GA3/zN7M8s0","jenny-jaumann","info@jennyjaumann.de","","2023-11-22 14:32:05","","0","Jenny Jaumann");

INSERT IGNORE INTO `dlhwp_usermeta` VALUES 
("1","1","nickname","Michael Albert"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","dlhwp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","dlhwp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","dlhwp_dashboard_quick_press_last_post_id","386"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:13:\"188.192.160.0\";}"),
("19","1","dlhwp_elementor_connect_common_data","a:6:{s:9:\"client_id\";s:32:\"Jk3P6KPxMdwqbZKY8jQE6rikJiab9w4O\";s:11:\"auth_secret\";s:32:\"xvHfL7FdnBNMhZHFzWO2LlsPxHhf6ZpE\";s:12:\"access_token\";s:295:\"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOjE2ODU0MjIsImF1ZCI6Imh0dHBzOi8vZGV2LmxlbmdhdWVyaG9mLmF0LyIsImNsaWVudF9pZCI6IkprM1A2S1B4TWR3cWJaS1k4alFFNnJpa0ppYWI5dzRPIiwiY29ubmVjdF90eXBlIjoiYWN0aXZhdGUiLCJpYXQiOjE3MDAwNTE2NTksImV4cCI6MzE3MjQ0NDk0MDU5fQ.D8pp20vLfE47S447A7HIQNj342RbiF3tqqI0kjf6N1M\";s:19:\"access_token_secret\";s:32:\"x2INiHOibggxFs9Cnn0x57XuKWIooVwk\";s:10:\"token_type\";s:6:\"bearer\";s:4:\"user\";O:8:\"stdClass\":1:{s:5:\"email\";s:23:\"michael@zahlenwerk21.de\";}}"),
("20","1","elementor_introduction","a:5:{s:27:\"ai-get-started-announcement\";b:1;s:7:\"exit_to\";b:1;s:6:\"e-apps\";b:1;s:20:\"globals_introduction\";b:1;s:14:\"ai_get_started\";b:1;}"),
("21","1","announcements_user_counter","1"),
("22","1","closedpostboxes_dashboard","a:0:{}"),
("23","1","metaboxhidden_dashboard","a:7:{i:0;s:24:\"wc_admin_dashboard_setup\";i:1;s:20:\"e-dashboard-overview\";i:2;s:19:\"dashboard_right_now\";i:3;s:18:\"dashboard_activity\";i:4;s:21:\"dashboard_quick_press\";i:5;s:17:\"dashboard_primary\";i:6;s:27:\"duplicator_dashboard_widget\";}"),
("24","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:81:\"e-dashboard-overview,dashboard_site_health,dashboard_right_now,dashboard_activity\";s:4:\"side\";s:67:\"dashboard_quick_press,dashboard_primary,duplicator_dashboard_widget\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("25","1","dlhwp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2023-07-27T18:18:52.509Z\";}"),
("26","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("27","1","metaboxhidden_nav-menus","a:2:{i:0;s:28:\"add-post-type-e-landing-page\";i:1;s:12:\"add-post_tag\";}"),
("28","1","elementor_preferences","a:1:{s:7:\"exit_to\";s:9:\"dashboard\";}"),
("29","1","dlhwp_user-settings","editor=tinymce&libraryContent=browse"),
("30","1","dlhwp_user-settings-time","1700075388"),
("31","1","default_password_nag",""),
("32","1","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.18.3\";}}}"),
("34","2","nickname","Corinna"),
("35","2","first_name","Corinna"),
("36","2","last_name","Charné"),
("37","2","description",""),
("38","2","rich_editing","true"),
("39","2","syntax_highlighting","true"),
("40","2","comment_shortcuts","false"),
("41","2","admin_color","fresh"),
("42","2","use_ssl","0"),
("43","2","show_admin_bar_front","true"),
("44","2","locale",""),
("45","2","dlhwp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("46","2","dlhwp_user_level","10"),
("47","2","dismissed_wp_pointers",""),
("48","1","_order_count","0"),
("49","1","_woocommerce_tracks_anon_id","woo:DBRhQ5oXitomqqKk5KsWPBXy"),
("50","1","wc_last_active","1700006400"),
("51","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("52","1","nav_menu_recently_edited","26"),
("53","1","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("54","3","nickname","Jenny Jaumann"),
("55","3","first_name","Jenny"),
("56","3","last_name","Jaumann"),
("57","3","description",""),
("58","3","rich_editing","true"),
("59","3","syntax_highlighting","true"),
("60","3","comment_shortcuts","false"),
("61","3","admin_color","fresh"),
("62","3","use_ssl","0"),
("63","3","show_admin_bar_front","true"),
("64","3","locale",""),
("65","3","dlhwp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("66","3","dlhwp_user_level","10"),
("67","3","dismissed_wp_pointers",""),
("68","3","default_password_nag",""),
("70","3","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.17.3\";}}}"),
("71","3","dlhwp_dashboard_quick_press_last_post_id","307"),
("72","3","community-events-location","a:1:{s:2:\"ip\";s:11:\"95.90.242.0\";}"),
("73","3","elementor_introduction","a:3:{s:6:\"e-apps\";b:1;s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("74","2","default_password_nag",""),
("76","2","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.18.3\";}}}"),
("77","2","dlhwp_dashboard_quick_press_last_post_id","353"),
("78","2","community-events-location","a:1:{s:2:\"ip\";s:11:\"24.134.18.0\";}"),
("79","2","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:16:\"favorites-notice\";b:1;}"),
("80","2","dlhwp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2023-11-24T12:19:32.308Z\";}"),
("82","3","dlhwp_user-settings","libraryContent=browse"),
("83","3","dlhwp_user-settings-time","1700836135"),
("84","3","dlhwp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:14:\"featured-image\";}}s:9:\"_modified\";s:24:\"2023-11-24T14:29:09.036Z\";}"),
("85","3","dlhwp_elementor_connect_common_data","a:3:{s:9:\"client_id\";s:32:\"8jcVYHdxvS3rF7f5qe4MEyccB2aNMfD9\";s:11:\"auth_secret\";s:32:\"bIc6AyzxzjplgygxRgha96exJx1Jpq2e\";s:5:\"state\";s:12:\"PgRQrZyWl20I\";}"),
("88","2","dlhwp_user-settings","libraryContent=browse&editor=tinymce"),
("89","2","dlhwp_user-settings-time","1703159250"),
("91","1","session_tokens","a:3:{s:64:\"98b67e4cfedec35ea993eff3dbfb730aae5df378ff78e56aab57fc3c4849ea06\";a:4:{s:10:\"expiration\";i:1705769775;s:2:\"ip\";s:13:\"24.134.18.101\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36\";s:5:\"login\";i:1705596975;}s:64:\"5c4b97dfd4b6a698ee9a69122d2eb18dad7d018c25db2307c0fe23fb725ed6de\";a:4:{s:10:\"expiration\";i:1705769839;s:2:\"ip\";s:13:\"24.134.18.101\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36\";s:5:\"login\";i:1705597039;}s:64:\"f14cde105ae8ca8c8c979ea12df85ede92051fde1ae3127dfd030e8ebca5de19\";a:4:{s:10:\"expiration\";i:1705770538;s:2:\"ip\";s:15:\"188.192.160.163\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36\";s:5:\"login\";i:1705597738;}}");

INSERT IGNORE INTO `dlhwp_actionscheduler_actions` VALUES 
("17","action_scheduler/migration_hook","complete","2023-11-15 12:41:57","2023-11-15 13:41:57","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700052117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700052117;}","1","1","2023-11-15 12:44:00","2023-11-15 13:44:00","0",NULL),
("18","woocommerce_cleanup_draft_orders","complete","2023-11-15 12:41:28","2023-11-15 13:41:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700052088;s:18:\"\0*\0first_timestamp\";i:1700052088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700052088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-15 12:41:29","2023-11-15 13:41:29","0",NULL),
("19","woocommerce_cleanup_draft_orders","pending","2023-11-16 12:41:29","2023-11-16 13:41:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700138489;s:18:\"\0*\0first_timestamp\";i:1700052088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700138489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("20","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2023-11-15 14:18:20","2023-11-15 15:18:20","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700057900;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700057900;}","3","1","2023-11-15 14:18:20","2023-11-15 15:18:20","0",NULL),
("21","action_scheduler/migration_hook","complete","2023-11-15 14:19:19","2023-11-15 15:19:19","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700057959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700057959;}","1","1","2023-11-15 17:59:06","2023-11-15 18:59:06","0",NULL),
("22","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2023-11-15 14:18:21","2023-11-15 15:18:21","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700057901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700057901;}","3","1","2023-11-15 17:59:06","2023-11-15 18:59:06","0",NULL);

INSERT IGNORE INTO `dlhwp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2",""),
("3","woocommerce-db-updates");

INSERT IGNORE INTO `dlhwp_actionscheduler_logs` VALUES 
("1","17","Aktion erstellt","2023-11-15 12:40:57","2023-11-15 13:40:57"),
("2","18","Aktion erstellt","2023-11-15 12:41:28","2023-11-15 13:41:28"),
("3","18","Aktion über Async Request gestartet","2023-11-15 12:41:29","2023-11-15 13:41:29"),
("4","18","Aktion über Async Request abgeschlossen","2023-11-15 12:41:29","2023-11-15 13:41:29"),
("5","19","Aktion erstellt","2023-11-15 12:41:29","2023-11-15 13:41:29"),
("6","17","Aktion über WP Cron gestartet","2023-11-15 12:44:00","2023-11-15 13:44:00"),
("7","17","Aktion über WP Cron abgeschlossen","2023-11-15 12:44:00","2023-11-15 13:44:00"),
("8","20","Aktion erstellt","2023-11-15 14:18:19","2023-11-15 15:18:19"),
("9","21","Aktion erstellt","2023-11-15 14:18:19","2023-11-15 15:18:19"),
("10","20","Aktion über WP Cron gestartet","2023-11-15 14:18:20","2023-11-15 15:18:20"),
("11","22","Aktion erstellt","2023-11-15 14:18:20","2023-11-15 15:18:20"),
("12","20","Aktion über WP Cron abgeschlossen","2023-11-15 14:18:20","2023-11-15 15:18:20"),
("13","22","Aktion über Async Request gestartet","2023-11-15 17:59:06","2023-11-15 18:59:06"),
("14","22","Aktion über Async Request abgeschlossen","2023-11-15 17:59:06","2023-11-15 18:59:06"),
("15","21","Aktion über Async Request gestartet","2023-11-15 17:59:06","2023-11-15 18:59:06"),
("16","21","Aktion über Async Request abgeschlossen","2023-11-15 17:59:06","2023-11-15 18:59:06");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("110","20231215_075931_dailylocal_lengauerhofde","b001bd860c7938b34083_20231215065931","-1","2023-12-15 06:59:31","unknown","{\n    \"ID\": 110,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231215_075931_dailylocal_lengauerhofde\",\n    \"Hash\": \"b001bd860c7938b34083_20231215065931\",\n    \"NameHash\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_scan.json\",\n    \"timer_start\": 1702623572.737949,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 224015711,\n        \"Dirs\": [],\n        \"DirCount\": 2452,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13119,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"DKW4qrEtx09FYnAu0A\\/Y847WVgFY9PWBM0xlSG+qVing77ZmK9IybQqhRLPq7KWZwJr1jY1tyG2SkL4qYPExvw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3569,\n            \"tablesSizeOnDisk\": 12894208,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 147456\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"437\",\n                    \"insertedRows\": 466,\n                    \"size\": 1654784\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2598,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 311,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6205608,\n        \"File\": \"20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-15 06:59:31\",\n    \"updated\": \"2023-12-15 06:59:46\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231215_075931_dailylocal_lengauerhofde_b001bd860c7938b34083_20231215065931_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-15 06:59:46"),
("111","20231215_075931_dailyonedirve_lengauerho","51352e16d2e767f08062_20231215065931","-2","2023-12-15 06:59:31","Corinna","{\n    \"ID\": 111,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231215_075931_dailyonedirve_lengauerho\",\n    \"Hash\": \"51352e16d2e767f08062_20231215065931\",\n    \"NameHash\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_scan.json\",\n    \"timer_start\": 1702623590.220249,\n    \"Runtime\": \"8.707 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.43MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97967185,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13119,\n        \"file_count\": 15571,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"zDbUkYvrfTD9PoEfPJFPxwK1k3dv\\/vBzb\\/s0EcgDvBm7OzZSkIgfcOLUx1XQDrEyY7R0vRuF17WF9iKPO+sT7A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3569,\n            \"tablesSizeOnDisk\": 12894208,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 147456\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"437\",\n                    \"insertedRows\": 450,\n                    \"size\": 1654784\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2598,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 311,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6049319,\n        \"File\": \"20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-15 06:59:31\",\n    \"updated\": \"2023-12-15 13:52:02\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231215_075931_dailyonedirve_lengauerho_51352e16d2e767f08062_20231215065931_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-15 13:52:02"),
("113","20231216_050304_dailyonedirve_lengauerho","c6212429ff3b7ec45794_20231216040304","-2","2023-12-16 04:03:04","unknown","{\n    \"ID\": 113,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231216_050304_dailyonedirve_lengauerho\",\n    \"Hash\": \"c6212429ff3b7ec45794_20231216040304\",\n    \"NameHash\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_scan.json\",\n    \"timer_start\": 1702699385.896486,\n    \"Runtime\": \"10.571 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97984174,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"O\\/26lPcYJAGG8W2G0\\/ouI7+oO9dOQCP+a2ghpx1QOtzeMZRZAM3+BvE2\\/0P8yXUPsDK3IkPdzNAlYPV6HKuJOw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3581,\n            \"tablesSizeOnDisk\": 12976128,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 5,\n                    \"size\": 245760\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"443\",\n                    \"insertedRows\": 449,\n                    \"size\": 1638400\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2427,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 287,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6093450,\n        \"File\": \"20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-16 04:03:04\",\n    \"updated\": \"2023-12-16 08:14:40\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231216_050304_dailyonedirve_lengauerho_c6212429ff3b7ec45794_20231216040304_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-16 08:14:40"),
("115","20231217_053042_dailyonedirve_lengauerho","9c746724402a1d808639_20231217043042","-2","2023-12-17 04:30:42","unknown","{\n    \"ID\": 115,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231217_053042_dailyonedirve_lengauerho\",\n    \"Hash\": \"9c746724402a1d808639_20231217043042\",\n    \"NameHash\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_scan.json\",\n    \"timer_start\": 1702787443.921922,\n    \"Runtime\": \"9.407 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97975586,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"DGlDBfNzG+AfU+xZFVTJRv79q0BrygSRfFvLSc7\\/OMWVvG3YpPszp0DvYeUZWYjYmp56tjeMYsUDqLrtXijGRQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3584,\n            \"tablesSizeOnDisk\": 14123008,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 344064\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"443\",\n                    \"insertedRows\": 447,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2427,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 287,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6084756,\n        \"File\": \"20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-17 04:30:42\",\n    \"updated\": \"2023-12-17 06:03:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231217_053042_dailyonedirve_lengauerho_9c746724402a1d808639_20231217043042_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-17 06:03:03"),
("117","20231218_040157_dailyonedirve_lengauerho","e30da44f5e8dc4c29977_20231218030157","-2","2023-12-18 03:01:57","unknown","{\n    \"ID\": 117,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231218_040157_dailyonedirve_lengauerho\",\n    \"Hash\": \"e30da44f5e8dc4c29977_20231218030157\",\n    \"NameHash\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_scan.json\",\n    \"timer_start\": 1702868519.082406,\n    \"Runtime\": \"9.822 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.45MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97985024,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"WXAYlNjHosZ9q7HxXafz6z4RtW\\/XU8FW2as+n1E\\/mhO7sYuAW+2+lX04Vf+D+UfjQWW6KM1SsIDM2qJLtVFdpQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3584,\n            \"tablesSizeOnDisk\": 14123008,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 9,\n                    \"size\": 344064\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"443\",\n                    \"insertedRows\": 449,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6166006,\n        \"File\": \"20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-18 03:01:57\",\n    \"updated\": \"2023-12-18 04:37:39\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231218_040157_dailyonedirve_lengauerho_e30da44f5e8dc4c29977_20231218030157_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-18 04:37:39"),
("119","20231219_084639_dailyonedirve_lengauerho","568f10695d1cb58d5555_20231219074639","-2","2023-12-19 07:46:39","unknown","{\n    \"ID\": 119,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231219_084639_dailyonedirve_lengauerho\",\n    \"Hash\": \"568f10695d1cb58d5555_20231219074639\",\n    \"NameHash\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_scan.json\",\n    \"timer_start\": 1702972019.228792,\n    \"Runtime\": \"8.995 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97977565,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"E2yJVaqluk7E4kuNdZJZwnMFRlDyWDjnBgPI9JLBzoEOLsV00c+bs8koQnY8hhlzRguXDL9JdC2Hdz72ft0Iyg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3590,\n            \"tablesSizeOnDisk\": 14221312,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 442368\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 448,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6160655,\n        \"File\": \"20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-19 07:46:39\",\n    \"updated\": \"2023-12-19 09:17:00\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231219_084639_dailyonedirve_lengauerho_568f10695d1cb58d5555_20231219074639_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-19 09:17:00");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("121","20231220_115359_dailyonedirve_lengauerho","a1346a572717a2d49381_20231220105359","-2","2023-12-20 10:53:59","unknown","{\n    \"ID\": 121,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231220_115359_dailyonedirve_lengauerho\",\n    \"Hash\": \"a1346a572717a2d49381_20231220105359\",\n    \"NameHash\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_scan.json\",\n    \"timer_start\": 1703069657.652264,\n    \"Runtime\": \"8.574 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.45MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97987696,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": 15573,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"P5MxmfPhBYUzzsNAvj3SQ3+c44EbPLdXuqMYHHPisIV1Sh6S612Sn5ZcdasdS4QttwISeGxortHe2jYMKTTnyw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3592,\n            \"tablesSizeOnDisk\": 15269888,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 450,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6262165,\n        \"File\": \"20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-20 10:53:59\",\n    \"updated\": \"2023-12-21 10:17:21\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231220_115359_dailyonedirve_lengauerho_a1346a572717a2d49381_20231220105359_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-21 10:17:21"),
("122","20231221_111721_dailylocal_lengauerhofde","e703cc0b0c5cd5354184_20231221101721","-1","2023-12-21 10:17:21","unknown","{\n    \"ID\": 122,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231221_111721_dailylocal_lengauerhofde\",\n    \"Hash\": \"e703cc0b0c5cd5354184_20231221101721\",\n    \"NameHash\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_scan.json\",\n    \"timer_start\": 1703153843.804641,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 224053613,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13121,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Cb8fxZDKBSVkEihI3B6Vg580WhZMT3miaPQzrWhhJIMIF8J87R814rt7tx0egElgeNAP8fHvLzC936npiKOe\\/w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3592,\n            \"tablesSizeOnDisk\": 15269888,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 15,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 449,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2375,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 278,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6292220,\n        \"File\": \"20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-21 10:17:21\",\n    \"updated\": \"2023-12-21 10:17:37\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231221_111721_dailylocal_lengauerhofde_e703cc0b0c5cd5354184_20231221101721_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-21 10:17:37"),
("123","20231221_111722_dailyonedirve_lengauerho","09b2bbbfccc6ed2a6238_20231221101722","-2","2023-12-21 10:17:22","Corinna","{\n    \"ID\": 123,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231221_111722_dailyonedirve_lengauerho\",\n    \"Hash\": \"09b2bbbfccc6ed2a6238_20231221101722\",\n    \"NameHash\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_scan.json\",\n    \"timer_start\": 1703153858.807954,\n    \"Runtime\": \"8.810 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"93.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 97978433,\n        \"Dirs\": [],\n        \"DirCount\": 2452,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13115,\n        \"file_count\": 15568,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"t02PiMJZjGgqWy7bxHKxxgbyC+Z5nzzaIMCmP6M+9yylkFWHHP5MkrMQiyz2iojED0+rT7fgpnO8cUl83LdS3g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3592,\n            \"tablesSizeOnDisk\": 15269888,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 15,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"445\",\n                    \"insertedRows\": 458,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2436\",\n                    \"insertedRows\": 2364,\n                    \"size\": 5013504\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 277,\n                    \"size\": 2703360\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6372728,\n        \"File\": \"20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-21 10:17:22\",\n    \"updated\": \"2023-12-21 11:47:54\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231221_111722_dailyonedirve_lengauerho_09b2bbbfccc6ed2a6238_20231221101722_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-21 11:47:54"),
("124","20231222_051800_dailylocal_lengauerhofde","32a7a58eb9be03f09248_20231222041800","-2","2023-12-22 04:18:00","unknown","{\n    \"ID\": 124,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231222_051800_dailylocal_lengauerhofde\",\n    \"Hash\": \"32a7a58eb9be03f09248_20231222041800\",\n    \"NameHash\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_scan.json\",\n    \"timer_start\": 1703218682.32059,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 296969361,\n        \"Dirs\": [],\n        \"DirCount\": 2452,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13182,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"WzPczj3h1dDlDj+WIxMQSRxI53j283F0\\/DwwzWZJOBQxTQZbmMi0jVIDLu4bUsi4zK9pce69wOKhLAlzAaY3yQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3692,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 467,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 304,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7568391,\n        \"File\": \"20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-22 04:18:00\",\n    \"updated\": \"2023-12-23 06:05:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231222_051800_dailylocal_lengauerhofde_32a7a58eb9be03f09248_20231222041800_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-23 06:05:59"),
("125","20231222_051800_dailyonedirve_lengauerho","04acf8b74060a3fc3729_20231222041800","-2","2023-12-22 04:18:00","unknown","{\n    \"ID\": 125,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231222_051800_dailyonedirve_lengauerho\",\n    \"Hash\": \"04acf8b74060a3fc3729_20231222041800\",\n    \"NameHash\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_scan.json\",\n    \"timer_start\": 1703311561.724161,\n    \"Runtime\": \"18.233 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.51MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170407110,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13182,\n        \"file_count\": 15634,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"kiWhulBHaSuAOg1sJE1nD4D2iEJEgQoVN4w3ARnRPvX585DTfyLFUBfcH5dEKOVnQLg+cQPBL0Q9Sme7neWntQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2526\",\n                    \"insertedRows\": 2548,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6764285,\n        \"File\": \"20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-22 04:18:00\",\n    \"updated\": \"2023-12-23 23:18:53\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231222_051800_dailyonedirve_lengauerho_04acf8b74060a3fc3729_20231222041800_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-23 23:18:53"),
("127","20231223_070559_dailyonedirve_lengauerho","96791c0ef57a61fc2836_20231223060559","-2","2023-12-23 06:05:59","unknown","{\n    \"ID\": 127,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231223_070559_dailyonedirve_lengauerho\",\n    \"Hash\": \"96791c0ef57a61fc2836_20231223060559\",\n    \"NameHash\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559\",\n    \"Type\": 1,\n    \"notes\": \"Erstellt mit Zeitplan daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_scan.json\",\n    \"timer_start\": 1703373550.251852,\n    \"Runtime\": \"10.681 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.5MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170394847,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"6c7g7khz9\\/dy773CbBDGycWMKv9TlwzwkguKTLNRvk1o+GDHlHHt8uwxOGPpL0rPt7QIRrkjEXF5PbjyPC+keg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2526\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6628369,\n        \"File\": \"20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-23 06:05:59\",\n    \"updated\": \"2023-12-24 09:15:49\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231223_070559_dailyonedirve_lengauerho_96791c0ef57a61fc2836_20231223060559_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-24 09:15:49");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("129","20231224_101549_dailyonedirve_lengauerho","775e70eecb47802b7392_20231224091549","-2","2023-12-24 09:15:49","unknown","{\n    \"ID\": 129,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231224_101549_dailyonedirve_lengauerho\",\n    \"Hash\": \"775e70eecb47802b7392_20231224091549\",\n    \"NameHash\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_scan.json\",\n    \"timer_start\": 1703409367.377978,\n    \"Runtime\": \"10.809 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170442457,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"D0iTKH2r73MahnE6ruIcZvft70iipqUUezBe4vnx2demL8RD5bYThp4yJZLHFcHI9peno9fxNC1mwx7XdrPfZw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"453\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6900236,\n        \"File\": \"20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-24 09:15:49\",\n    \"updated\": \"2023-12-24 22:02:27\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231224_101549_dailyonedirve_lengauerho_775e70eecb47802b7392_20231224091549_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-24 22:02:27"),
("131","20231226_041132_dailyonedirve_lengauerho","1e6d0962d919bdb82735_20231226031132","-2","2023-12-26 03:11:32","unknown","{\n    \"ID\": 131,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231226_041132_dailyonedirve_lengauerho\",\n    \"Hash\": \"1e6d0962d919bdb82735_20231226031132\",\n    \"NameHash\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_scan.json\",\n    \"timer_start\": 1703560313.495667,\n    \"Runtime\": \"10.976 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170442516,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"YDS9Bwya46pDsAPOLwkkiFpKMHtv3byb+asKMIzVm93hljeXllKPCQMU1HtVq4JI\\/gHozPEvGHZCJqo2IGeDcQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3694,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 23,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"452\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6945368,\n        \"File\": \"20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-26 03:11:32\",\n    \"updated\": \"2023-12-26 07:43:43\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231226_041132_dailyonedirve_lengauerho_1e6d0962d919bdb82735_20231226031132_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-26 07:43:43"),
("133","20231227_061431_dailyonedirve_lengauerho","67b8a488d1cbb48c6991_20231227051431","-2","2023-12-27 05:14:31","unknown","{\n    \"ID\": 133,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231227_061431_dailyonedirve_lengauerho\",\n    \"Hash\": \"67b8a488d1cbb48c6991_20231227051431\",\n    \"NameHash\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_scan.json\",\n    \"timer_start\": 1703654093.613802,\n    \"Runtime\": \"10.588 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170444436,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"q\\/ds\\/y5rKps8IdAWW2JR\\/FxFXdDma7NEZRQlGvMZA7RUJDS8Lb5L4I\\/GSybHuAA0SwuR\\/YQfdAE3uSo3IE5iZg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3700,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 24,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6970803,\n        \"File\": \"20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-27 05:14:31\",\n    \"updated\": \"2023-12-27 23:57:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231227_061431_dailyonedirve_lengauerho_67b8a488d1cbb48c6991_20231227051431_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-27 23:57:17"),
("135","20231228_042354_dailyonedirve_lengauerho","94e70ff93c5569792193_20231228032354","-2","2023-12-28 03:23:54","unknown","{\n    \"ID\": 135,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231228_042354_dailyonedirve_lengauerho\",\n    \"Hash\": \"94e70ff93c5569792193_20231228032354\",\n    \"NameHash\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_scan.json\",\n    \"timer_start\": 1703733835.110167,\n    \"Runtime\": \"12.446 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170453228,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"H8H+ONkGXc49Gotw\\/q+URHtANCz1Z2TcokrJJciXhgvpBRh2lT9D062aTamLPC3RfYmDApLWech4sZ9p9VtmSg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3700,\n            \"tablesSizeOnDisk\": 15908864,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 1490944\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"454\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7046768,\n        \"File\": \"20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-28 03:23:54\",\n    \"updated\": \"2023-12-28 04:57:52\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231228_042354_dailyonedirve_lengauerho_94e70ff93c5569792193_20231228032354_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-28 04:57:52"),
("137","20231229_040634_dailyonedirve_lengauerho","a587455abfc76c624533_20231229030634","-2","2023-12-29 03:06:34","unknown","{\n    \"ID\": 137,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231229_040634_dailyonedirve_lengauerho\",\n    \"Hash\": \"a587455abfc76c624533_20231229030634\",\n    \"NameHash\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_scan.json\",\n    \"timer_start\": 1703819195.110742,\n    \"Runtime\": \"11.808 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170453581,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"4nCFtBs50LA+nuxogBc0g+VQQPmWkQeLGossN0bRT0kCe7z8eQSDzGCe0ktIcdoIJcxa6nmvU4S9fy89UQergw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3683,\n            \"tablesSizeOnDisk\": 15843328,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 1425408\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7071709,\n        \"File\": \"20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-29 03:06:34\",\n    \"updated\": \"2023-12-29 04:38:32\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231229_040634_dailyonedirve_lengauerho_a587455abfc76c624533_20231229030634_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-29 04:38:32"),
("139","20231230_040058_dailyonedirve_lengauerho","d4e53a0f17b9cd791351_20231230030058","-2","2023-12-30 03:00:58","unknown","{\n    \"ID\": 139,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231230_040058_dailyonedirve_lengauerho\",\n    \"Hash\": \"d4e53a0f17b9cd791351_20231230030058\",\n    \"NameHash\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_scan.json\",\n    \"timer_start\": 1703905259.45322,\n    \"Runtime\": \"11.630 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170454260,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"cN+jhRTgAO+omYHR4UJ8xKqlNeKwLIu85m3mKLOY+RAVaHxcrjD7V+ttp\\/0YN1wQdOCQxiTaqsmhhlu+XNQWQA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3684,\n            \"tablesSizeOnDisk\": 15810560,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 27,\n                    \"size\": 1392640\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7095660,\n        \"File\": \"20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-30 03:00:58\",\n    \"updated\": \"2023-12-30 04:36:36\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231230_040058_dailyonedirve_lengauerho_d4e53a0f17b9cd791351_20231230030058_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-30 04:36:36");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("141","20231231_053936_dailyonedirve_lengauerho","d005caa630df8b1d7502_20231231043936","-2","2023-12-31 04:39:36","unknown","{\n    \"ID\": 141,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231231_053936_dailyonedirve_lengauerho\",\n    \"Hash\": \"d005caa630df8b1d7502_20231231043936\",\n    \"NameHash\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_scan.json\",\n    \"timer_start\": 1703997596.892447,\n    \"Runtime\": \"10.568 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170454898,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"XLwtJdMRpyjPb8jMie2s5J5xSNR22giO4IpEN8seUyt60ga8xPRyxubC4\\/qX0N1XyckjHvzIgdiEcBpbQrVBrg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3686,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 28,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7119340,\n        \"File\": \"20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:39:36\",\n    \"updated\": \"2023-12-31 06:18:23\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20231231_053936_dailyonedirve_lengauerho_d005caa630df8b1d7502_20231231043936_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2023-12-31 06:18:23"),
("142","20240102_054232_dailylocal_lengauerhofde","7008d4b9e0441d7e2140_20240102044232","100","2024-01-02 04:42:32","unknown","{\n    \"ID\": 142,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240102_054232_dailylocal_lengauerhofde\",\n    \"Hash\": \"7008d4b9e0441d7e2140_20240102044232\",\n    \"NameHash\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_scan.json\",\n    \"timer_start\": 1704170554.502641,\n    \"Runtime\": \"15.921 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170447521,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"JHx3pOLQolBKMiT8w6mQQde6DfQziv\\/EQS99mAvbqclyZvxErT1l0VEgCVkJgcUPvdaS0lF0ctxiEhBvj\\/G\\/QQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3689,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7095320,\n        \"File\": \"20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704170570,\n            \"stopped_timestamp\": 1704170570,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-02 04:42:32\",\n    \"updated\": \"2024-01-02 04:42:50\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240102_054232_dailylocal_lengauerhofde_7008d4b9e0441d7e2140_20240102044232_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-02 04:42:50"),
("143","20240102_054232_dailyonedirve_lengauerho","d2f912c1400693ad7682_20240102044232","-2","2024-01-02 04:42:32","unknown","{\n    \"ID\": 143,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240102_054232_dailyonedirve_lengauerho\",\n    \"Hash\": \"d2f912c1400693ad7682_20240102044232\",\n    \"NameHash\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_scan.json\",\n    \"timer_start\": 1704170571.545595,\n    \"Runtime\": \"10.540 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170446141,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"DKdjj76Fh2IMmGOuprR03toiEsEPvAd8TCWmCg9NR4v3GMwX5N\\/ORG4sDPN27N0lRf5uX4vDJaE8xJnRc3kFxg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3689,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 29,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7088438,\n        \"File\": \"20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-02 04:42:32\",\n    \"updated\": \"2024-01-02 07:29:40\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240102_054232_dailyonedirve_lengauerho_d2f912c1400693ad7682_20240102044232_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-02 07:29:40"),
("144","20240103_160024_dailylocal_lengauerhofde","536054ee48b3e3815140_20240103150024","100","2024-01-03 15:00:24","unknown","{\n    \"ID\": 144,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240103_160024_dailylocal_lengauerhofde\",\n    \"Hash\": \"536054ee48b3e3815140_20240103150024\",\n    \"NameHash\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_scan.json\",\n    \"timer_start\": 1704294026.888295,\n    \"Runtime\": \"17.178 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170447947,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"UVAE4zIsfdik6c6wQPir\\/jnMoqInvbVwBam4VM1yyj2Glkde8227hA+d1gImxxGROnZ0TseUawtT7xuCJFjimA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3692,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7119926,\n        \"File\": \"20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704294044,\n            \"stopped_timestamp\": 1704294044,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-03 15:00:24\",\n    \"updated\": \"2024-01-03 15:00:44\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240103_160024_dailylocal_lengauerhofde_536054ee48b3e3815140_20240103150024_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-03 15:00:44"),
("145","20240103_160024_dailyonedirve_lengauerho","dc72d38063211d348944_20240103150024","-2","2024-01-03 15:00:24","unknown","{\n    \"ID\": 145,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240103_160024_dailyonedirve_lengauerho\",\n    \"Hash\": \"dc72d38063211d348944_20240103150024\",\n    \"NameHash\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_scan.json\",\n    \"timer_start\": 1704294045.254729,\n    \"Runtime\": \"11.182 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170448110,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"5wBhjsTH+oNGdER9IGNwa\\/\\/DWDj237QXmLRFRwMtMxDt\\/G9l3+zvJoN8jgpoErCFoac96+NSUz\\/VgE1kVx\\/+8A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3692,\n            \"tablesSizeOnDisk\": 15777792,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 1359872\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7137573,\n        \"File\": \"20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-03 15:00:24\",\n    \"updated\": \"2024-01-03 16:56:06\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240103_160024_dailyonedirve_lengauerho_dc72d38063211d348944_20240103150024_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-03 16:56:06"),
("146","20240105_083340_dailylocal_lengauerhofde","72b5027acc5e7f8f8564_20240105073340","100","2024-01-05 07:33:40","unknown","{\n    \"ID\": 146,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240105_083340_dailylocal_lengauerhofde\",\n    \"Hash\": \"72b5027acc5e7f8f8564_20240105073340\",\n    \"NameHash\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_scan.json\",\n    \"timer_start\": 1704440021.95278,\n    \"Runtime\": \"21.078 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170451329,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"pMi4KQcGxSH94SOJ0G2JRGG1zmAKLWIu8G\\/ITfmyvj7FHZVff8\\/PJdc8x3+SVQHX4dgRhzJ2O1gvcqS7YIO1JA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3694,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7168376,\n        \"File\": \"20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704440043,\n            \"stopped_timestamp\": 1704440043,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-05 07:33:40\",\n    \"updated\": \"2024-01-05 07:34:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240105_083340_dailylocal_lengauerhofde_72b5027acc5e7f8f8564_20240105073340_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-05 07:34:03");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("147","20240105_083340_dailyonedirve_lengauerho","9b7d90243e47e4694602_20240105073340","-2","2024-01-05 07:33:40","unknown","{\n    \"ID\": 147,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240105_083340_dailyonedirve_lengauerho\",\n    \"Hash\": \"9b7d90243e47e4694602_20240105073340\",\n    \"NameHash\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_scan.json\",\n    \"timer_start\": 1704440044.382361,\n    \"Runtime\": \"10.766 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170460311,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8mqgpdE0T4pXsOeCqY2c+RiAfI\\/xzPllisE+\\/UzDPYcEL1tzu6sgAU2Ucg3hT0bAYPoc9zMBJLkkMt+31Phl8Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3694,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 32,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7216052,\n        \"File\": \"20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-05 07:33:40\",\n    \"updated\": \"2024-01-05 15:49:15\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240105_083340_dailyonedirve_lengauerho_9b7d90243e47e4694602_20240105073340_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-05 15:49:15"),
("148","20240106_145825_dailylocal_lengauerhofde","d0439d9f55a63b0b4006_20240106135825","100","2024-01-06 13:58:25","unknown","{\n    \"ID\": 148,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240106_145825_dailylocal_lengauerhofde\",\n    \"Hash\": \"d0439d9f55a63b0b4006_20240106135825\",\n    \"NameHash\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_scan.json\",\n    \"timer_start\": 1704549507.416855,\n    \"Runtime\": \"17.267 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170452125,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8bLelBWqleKKBR2Y\\/Zu5l71KPcMn1cyh9GG7dWS\\/or3JvF6x1VRLBJUj2+XCPVReWKrTsbD3U5kHnTs55V3+Cg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 34,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7192433,\n        \"File\": \"20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704549524,\n            \"stopped_timestamp\": 1704549524,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-06 13:58:25\",\n    \"updated\": \"2024-01-06 13:58:45\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240106_145825_dailylocal_lengauerhofde_d0439d9f55a63b0b4006_20240106135825_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-06 13:58:45"),
("149","20240106_145825_dailyonedirve_lengauerho","b843fa9f6af5c1b89337_20240106135825","-2","2024-01-06 13:58:25","unknown","{\n    \"ID\": 149,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240106_145825_dailyonedirve_lengauerho\",\n    \"Hash\": \"b843fa9f6af5c1b89337_20240106135825\",\n    \"NameHash\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_scan.json\",\n    \"timer_start\": 1704549525.883232,\n    \"Runtime\": \"10.676 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170451274,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"M2KiNsHcg0aciKY9bp5UgHEHQ2Wa8VYANoxnhxSkvajemISz\\/YZWYfFu\\/vnNAcNKwp5QiN8k9g+2qXruBnd5Yw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 33,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7185537,\n        \"File\": \"20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-06 13:58:25\",\n    \"updated\": \"2024-01-06 18:16:41\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240106_145825_dailyonedirve_lengauerho_b843fa9f6af5c1b89337_20240106135825_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-06 18:16:41"),
("150","20240107_055511_dailylocal_lengauerhofde","95f99d700eb42bde6327_20240107045511","100","2024-01-07 04:55:11","unknown","{\n    \"ID\": 150,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240107_055511_dailylocal_lengauerhofde\",\n    \"Hash\": \"95f99d700eb42bde6327_20240107045511\",\n    \"NameHash\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_scan.json\",\n    \"timer_start\": 1704603313.556013,\n    \"Runtime\": \"18.655 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170450118,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"C8+dh+ejNZlEV2UWtAZ8PZQqR3G5O5tzyIEEofkU1MiNJY51QHmS2C0FxDRgYpz3vatd4Gihypzb2bAU9SYyuQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 35,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7213901,\n        \"File\": \"20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704603332,\n            \"stopped_timestamp\": 1704603332,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-07 04:55:11\",\n    \"updated\": \"2024-01-07 04:55:32\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240107_055511_dailylocal_lengauerhofde_95f99d700eb42bde6327_20240107045511_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-07 04:55:32"),
("151","20240107_055511_dailyonedirve_lengauerho","c9fb6ebe56e13ef69650_20240107045511","-2","2024-01-07 04:55:11","unknown","{\n    \"ID\": 151,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240107_055511_dailyonedirve_lengauerho\",\n    \"Hash\": \"c9fb6ebe56e13ef69650_20240107045511\",\n    \"NameHash\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_scan.json\",\n    \"timer_start\": 1704603333.466552,\n    \"Runtime\": \"10.654 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170451277,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"0RKGAMcagQRSlRiO6VkFHv5ACgUzLl4UyVIjmpemoUxIfKewbJJHpY5q5NBhvy714FXCPdbvItWKzr3m4B2uww==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 34,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 443,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7207014,\n        \"File\": \"20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-07 04:55:11\",\n    \"updated\": \"2024-01-07 06:55:16\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240107_055511_dailyonedirve_lengauerho_c9fb6ebe56e13ef69650_20240107045511_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-07 06:55:16"),
("152","20240108_050913_dailylocal_lengauerhofde","d2183b30be9f900c2532_20240108040913","100","2024-01-08 04:09:13","unknown","{\n    \"ID\": 152,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240108_050913_dailylocal_lengauerhofde\",\n    \"Hash\": \"d2183b30be9f900c2532_20240108040913\",\n    \"NameHash\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_scan.json\",\n    \"timer_start\": 1704686955.507737,\n    \"Runtime\": \"18.012 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170460028,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"N24dQJ3Dogml72SmB8sk+c\\/6QUVlzC\\/HUrbSdZPTyKne\\/vjGsCxAeYlWI\\/wN8R+Yy47JOYEAWRyymThV2jKPDg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7291729,\n        \"File\": \"20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704686973,\n            \"stopped_timestamp\": 1704686973,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-08 04:09:13\",\n    \"updated\": \"2024-01-08 04:09:33\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240108_050913_dailylocal_lengauerhofde_d2183b30be9f900c2532_20240108040913_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-08 04:09:33");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("153","20240108_050913_dailyonedirve_lengauerho","6177162272cb7ddd7144_20240108040913","-2","2024-01-08 04:09:13","unknown","{\n    \"ID\": 153,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240108_050913_dailyonedirve_lengauerho\",\n    \"Hash\": \"6177162272cb7ddd7144_20240108040913\",\n    \"NameHash\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_scan.json\",\n    \"timer_start\": 1704686974.751008,\n    \"Runtime\": \"10.933 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170461460,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"ae\\/u6Xsq7edP8fyFtYL9TTxh5CNiV8toVI43ndht8CQ+ijXuEsN8oMX5EO7TkhmSy+CRXm9Mtm2pEfGLb1QUgw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 35,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"Percona Server (GPL), Release \'26\', Revision \'0fe62c85\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7284796,\n        \"File\": \"20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;26&#039;, Revision &#039;0fe62c85&#039;\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-08 04:09:13\",\n    \"updated\": \"2024-01-08 05:45:26\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240108_050913_dailyonedirve_lengauerho_6177162272cb7ddd7144_20240108040913_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.14.2","2024-01-08 05:45:26"),
("154","20240109_030534_dailylocal_lengauerhofde","e71949056e3ab26d5931_20240109020534","100","2024-01-09 02:05:34","unknown","{\n    \"ID\": 154,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240109_030534_dailylocal_lengauerhofde\",\n    \"Hash\": \"e71949056e3ab26d5931_20240109020534\",\n    \"NameHash\": \"20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534_scan.json\",\n    \"timer_start\": 1704765937.242758,\n    \"Runtime\": \"18.730 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170459619,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"N5VogyZWI4TW6dVtx51YJ\\/ggIBN9qp6zRaqPtyOx\\/iGiDmPP2+GSuIVbgmcp\\/MyaaW1OCReZnRJKuqHrAsao+g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7307919,\n        \"File\": \"20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704765956,\n            \"stopped_timestamp\": 1704765956,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-09 02:05:34\",\n    \"updated\": \"2024-01-09 02:05:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240109_030534_dailylocal_lengauerhofde_e71949056e3ab26d5931_20240109020534_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","4.5.14.2","2024-01-09 02:05:56"),
("155","20240109_040908_dailyonedirve_lengauerho","8182fa7bd88d1da11678_20240109030908","-2","2024-01-09 03:09:08","Michael Albert","{\n    \"ID\": 155,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240109_040908_dailyonedirve_lengauerho\",\n    \"Hash\": \"8182fa7bd88d1da11678_20240109030908\",\n    \"NameHash\": \"20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908_scan.json\",\n    \"timer_start\": 1704769749.406244,\n    \"Runtime\": \"11.830 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170459613,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"W\\/\\/TGWHfw9Kef8g7W9q5jQxLJT3MhxHfElUvBm6iPv9Zff1i0nZjQDrHfv4m+4V9NTzIgwMCM2WapNYx3vu7PA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3695,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7307999,\n        \"File\": \"20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-09 03:09:08\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"CREATED_AFTER_RESTORE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240109_040908_dailyonedirve_lengauerho_8182fa7bd88d1da11678_20240109030908_archive.zip","-2","SCHEDULE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17"),
("156","20240110_152437_dailylocal_lengauerhofde","ba3ced151398c5e24164_20240110142437","100","2024-01-10 14:24:37","Michael Albert","{\n    \"ID\": 156,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240110_152437_dailylocal_lengauerhofde\",\n    \"Hash\": \"ba3ced151398c5e24164_20240110142437\",\n    \"NameHash\": \"20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437_scan.json\",\n    \"timer_start\": 1704896680.370185,\n    \"Runtime\": \"18.490 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170460124,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"FaJFcQ0UrZil8jfz695Kc5UEKP\\/jY2F5HmwFh4mwtf\\/zft8LhjMU\\/O2WCM+Ru+6IuZ74M9bSB09BLd46ylib5A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3699,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 38,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 446,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7339862,\n        \"File\": \"20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704896699,\n            \"stopped_timestamp\": 1704896699,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-10 14:24:37\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": {\n        \"0\": \"SCHEDULE\",\n        \"1\": \"ZIP_ARCHIVE\",\n        \"4\": \"CREATED_AFTER_RESTORE\",\n        \"5\": \"HAVE_LOCAL\",\n        \"6\": \"DISASTER_AVAIABLE\"\n    },\n    \"flagUpdatedAfterLoad\": false\n}","20240110_152437_dailylocal_lengauerhofde_ba3ced151398c5e24164_20240110142437_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17"),
("157","20240110_152437_dailyonedirve_lengauerho","9ae8d9fb429af0ca6406_20240110142437","-2","2024-01-10 14:24:37","Michael Albert","{\n    \"ID\": 157,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240110_152437_dailyonedirve_lengauerho\",\n    \"Hash\": \"9ae8d9fb429af0ca6406_20240110142437\",\n    \"NameHash\": \"20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437_scan.json\",\n    \"timer_start\": 1704896700.520559,\n    \"Runtime\": \"11.244 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.55MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170450447,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"CFKrMJdVZ42pUXHYn4VS\\/NjpdOTHzpHckE\\/lDVigz6QxV7Ul7aP8AUbVTHi7r0s9Dkvt9qot69vzSzs\\/bProcg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3699,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 37,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 442,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7279309,\n        \"File\": \"20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-10 14:24:37\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"CREATED_AFTER_RESTORE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240110_152437_dailyonedirve_lengauerho_9ae8d9fb429af0ca6406_20240110142437_archive.zip","-2","SCHEDULE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17"),
("158","20240111_041548_dailylocal_lengauerhofde","437733781279a4768239_20240111031548","100","2024-01-11 03:15:48","Michael Albert","{\n    \"ID\": 158,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240111_041548_dailylocal_lengauerhofde\",\n    \"Hash\": \"437733781279a4768239_20240111031548\",\n    \"NameHash\": \"20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548_scan.json\",\n    \"timer_start\": 1704942951.992918,\n    \"Runtime\": \"18.665 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170460321,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"uZyX7i2B3yM9aF9it1CYsBlfW06kNc0NSKsjD9QXSUhfpxO3Gj9w+Q3w+GozjGWV0JNAbl5bMXk35T0cQCwe9g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3699,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 39,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7362310,\n        \"File\": \"20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704942970,\n            \"stopped_timestamp\": 1704942971,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-11 03:15:48\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": {\n        \"0\": \"SCHEDULE\",\n        \"1\": \"ZIP_ARCHIVE\",\n        \"4\": \"CREATED_AFTER_RESTORE\",\n        \"5\": \"HAVE_LOCAL\",\n        \"6\": \"DISASTER_AVAIABLE\"\n    },\n    \"flagUpdatedAfterLoad\": false\n}","20240111_041548_dailylocal_lengauerhofde_437733781279a4768239_20240111031548_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17");

INSERT IGNORE INTO `dlhwp_duplicator_backups` VALUES 
("159","20240111_041548_dailyonedirve_lengauerho","44b9242d41a4c3651937_20240111031548","-2","2024-01-11 03:15:48","Michael Albert","{\n    \"ID\": 159,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240111_041548_dailyonedirve_lengauerho\",\n    \"Hash\": \"44b9242d41a4c3651937_20240111031548\",\n    \"NameHash\": \"20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548_scan.json\",\n    \"timer_start\": 1704942972.038511,\n    \"Runtime\": \"10.920 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170459334,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"rHrIsdGN56YOLSlIkaFF214Iiql+2tjjiXBFkzB4+7DwiIsdez+tOruPU\\/DiYIcQCUeDsNUCOBU+lfZYCXDhPQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3699,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 38,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"440\",\n                    \"insertedRows\": 445,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7355352,\n        \"File\": \"20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-11 03:15:48\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"CREATED_AFTER_RESTORE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240111_041548_dailyonedirve_lengauerho_44b9242d41a4c3651937_20240111031548_archive.zip","-2","SCHEDULE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17"),
("160","20240112_033041_dailylocal_lengauerhofde","af9b654ec1e5682d2874_20240112023041","100","2024-01-12 02:30:41","Michael Albert","{\n    \"ID\": 160,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240112_033041_dailylocal_lengauerhofde\",\n    \"Hash\": \"af9b654ec1e5682d2874_20240112023041\",\n    \"NameHash\": \"20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041_scan.json\",\n    \"timer_start\": 1705026643.491865,\n    \"Runtime\": \"16.271 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170459727,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"dNwvOuddiEjVPY\\/BP8Vc\\/7lYy\\/OQgLKhxMZ7SH8lwAZTnyazUSedvqLV4BlQ0fsFpK++wtFQVjUk3guGzWLjZA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3698,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7378859,\n        \"File\": \"20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 14,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 9,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1705026659,\n            \"stopped_timestamp\": 1705026660,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 9,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-12 02:30:41\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": {\n        \"0\": \"SCHEDULE\",\n        \"1\": \"ZIP_ARCHIVE\",\n        \"4\": \"CREATED_AFTER_RESTORE\",\n        \"5\": \"HAVE_LOCAL\",\n        \"6\": \"DISASTER_AVAIABLE\"\n    },\n    \"flagUpdatedAfterLoad\": false\n}","20240112_033041_dailylocal_lengauerhofde_af9b654ec1e5682d2874_20240112023041_archive.zip","100","SCHEDULE,HAVE_LOCAL,DISASTER_AVAIABLE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17"),
("161","20240112_042902_dailyonedirve_lengauerho","d0b056d8b35b56215186_20240112032902","-2","2024-01-12 03:29:02","Michael Albert","{\n    \"ID\": 161,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240112_042902_dailyonedirve_lengauerho\",\n    \"Hash\": \"d0b056d8b35b56215186_20240112032902\",\n    \"NameHash\": \"20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily one dirve\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902_scan.json\",\n    \"timer_start\": 1705030143.509725,\n    \"Runtime\": \"12.056 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170459764,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902_installer.php\",\n        \"Size\": 131964,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"J8N7jCJD\\/eEc88wbNRZsFj6l9+mbKMbx0rDhU0uhA7EXCaoKcxzm6aXkuMAqm0vS2TjUS70dovBXFmi0gM0ztA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3698,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"438\",\n                    \"insertedRows\": 444,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"Percona Server (GPL), Release \'27\', Revision \'2f8eeab2\'$\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7378885,\n        \"File\": \"20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;27&#039;, Revision &#039;2f8eeab2&#039;$\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\\/20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -2,\n    \"schedule_id\": 15,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2024-01-12 03:29:02\",\n    \"updated\": \"2024-01-18 16:56:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"CREATED_AFTER_RESTORE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240112_042902_dailyonedirve_lengauerho_d0b056d8b35b56215186_20240112032902_archive.zip","-2","SCHEDULE,CREATED_AFTER_RESTORE,ZIP_ARCHIVE","4.5.14.2","2024-01-18 16:56:17"),
("162","20240113_034217_dailylocal_lengauerhofde","d29e220b44eb42c31738_20240113024217","100","2024-01-13 02:42:17","Michael Albert","{\n    \"ID\": 162,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240113_034217_dailylocal_lengauerhofde\",\n    \"Hash\": \"d29e220b44eb42c31738_20240113024217\",\n    \"NameHash\": \"20240113_034217_dailylocal_lengauerhofde_d29e220b44eb42c31738_20240113024217\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule daily local\",\n    \"StorePath\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/dev.lengauerhof.at\\/dev\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240113_034217_dailylocal_lengauerhofde_d29e220b44eb42c31738_20240113024217_scan.json\",\n    \"timer_start\": 1705113739.611239,\n    \"Runtime\": \"17.438 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"162.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.opcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.tmb\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/wpvividbackups\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.htaccess\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/.user.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/php.ini\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/web.config\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-config.php\",\n            \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240113_034217_dailylocal_lengauerhofde_d29e220b44eb42c31738_20240113024217_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/tophosting\\/conova\\/vhost_42555\\/dev\",\n        \"Size\": 170461092,\n        \"Dirs\": [],\n        \"DirCount\": 2451,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13189,\n        \"file_count\": 15641,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240113_034217_dailylocal_lengauerhofde_d29e220b44eb42c31738_20240113024217_installer.php\",\n        \"Size\": 131962,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"qy+VWWwYeH9eI09yRp9YZSKtbXHL4ZLddexXPHyq++lOX3Tgz9igXl\\/i1EmZMvDFJNvehID2S983UVp9TmpsLg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"db1da42c8f\",\n            \"tablesBaseCount\": 58,\n            \"tablesFinalCount\": 58,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 3702,\n            \"tablesSizeOnDisk\": 16826368,\n            \"tablesList\": {\n                \"dlhwp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 131072\n                },\n                \"dlhwp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 32768\n                },\n                \"dlhwp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                },\n                \"dlhwp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_duplicator_backups\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 40,\n                    \"size\": 2408448\n                },\n                \"dlhwp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 163840\n                },\n                \"dlhwp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"dlhwp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"dlhwp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_options\": {\n                    \"inaccurateRows\": \"441\",\n                    \"insertedRows\": 447,\n                    \"size\": 2686976\n                },\n                \"dlhwp_postmeta\": {\n                    \"inaccurateRows\": \"2537\",\n                    \"insertedRows\": 2559,\n                    \"size\": 4833280\n                },\n                \"dlhwp_posts\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 303,\n                    \"size\": 3522560\n                },\n                \"dlhwp_term_relationships\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 54,\n                    \"size\": 32768\n                },\n                \"dlhwp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_termmeta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"dlhwp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 49152\n                },\n                \"dlhwp_usermeta\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 84,\n                    \"size\": 49152\n                },\n                \"dlhwp_users\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 91,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"dlhwp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"dlhwp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"dlhwp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"dlhwp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"dlhwp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"dlhwp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"dlhwp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"dlhwp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                